/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.block;

import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.custom.block.EVDirtBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;

public class EVFarmlandBlock
extends FarmBlock {
    public EVFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moisture = (Integer)state.getValue((Property)MOISTURE);
        if (!EVFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.isRainingAt(pos.above())) {
            if (moisture > 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(moisture - 1)), 2);
            } else if (!EVFarmlandBlock.shouldMaintainFarmland((BlockGetter)level, pos)) {
                EVFarmlandBlock.turnToEnrichedDirt(null, state, (Level)level, pos);
            }
        } else if (moisture < 7) {
            level.setBlock(pos, (BlockState)state.setValue((Property)MOISTURE, (Comparable)Integer.valueOf(7)), 2);
        }
        BlockPos abovePos = pos.above();
        BlockState plantState = level.getBlockState(abovePos);
        Block block = plantState.getBlock();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock plant = (BonemealableBlock)block;
            if (random.nextFloat() < 0.2f && plant.isValidBonemealTarget((LevelReader)level, abovePos, plantState)) {
                plant.performBonemeal(level, random, abovePos, plantState);
            }
        }
    }

    public void fallOn(Level level, BlockState blockState, BlockPos pos, Entity entity, double fallDistance) {
        ServerLevel serverlevel;
        if (level instanceof ServerLevel && CommonHooks.onFarmlandTrample((ServerLevel)(serverlevel = (ServerLevel)level), (BlockPos)pos, (BlockState)((EVDirtBlock)((Object)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())).defaultBlockState(), (double)fallDistance, (Entity)entity)) {
            EVFarmlandBlock.turnToDirt((Entity)entity, (BlockState)blockState, (Level)level, (BlockPos)pos);
        }
        super.fallOn(level, blockState, pos, entity, fallDistance);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)level, pos)) {
            EVFarmlandBlock.turnToEnrichedDirt(null, state, (Level)level, pos);
        }
    }

    public static void turnToEnrichedDirt(Entity entity, BlockState state, Level level, BlockPos pos) {
        BlockState newState = EVFarmlandBlock.pushEntitiesUp((BlockState)state, (BlockState)((EVDirtBlock)((Object)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())).defaultBlockState(), (LevelAccessor)level, (BlockPos)pos);
        level.setBlockAndUpdate(pos, newState);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)entity, (BlockState)newState));
    }

    private static boolean shouldMaintainFarmland(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearWater(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 0, -4), (BlockPos)pos.offset(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)world, pos, world.getFluidState(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)world, (BlockPos)pos);
    }
}

