/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.block;

import com.mojang.serialization.MapCodec;
import de.bigbull.vibranium.init.BlockInit;
import de.bigbull.vibranium.init.ItemInit;
import de.bigbull.vibranium.init.ParticleInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class HSHBushBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<HSHBushBlock> CODEC = HSHBushBlock.simpleCodec(HSHBushBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SHAPE_SAPLING = Block.column((double)10.0, (double)0.0, (double)8.0);
    private static final VoxelShape SHAPE_GROWING = Block.column((double)14.0, (double)0.0, (double)16.0);

    public MapCodec<HSHBushBlock> codec() {
        return CODEC;
    }

    public HSHBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState soil = worldIn.getBlockState(pos.below());
        return soil.is((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get()) || soil.is((Block)BlockInit.ENRICHED_VIBRANIUM_FARMLAND.get());
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter world, BlockPos pos) {
        return state.is((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get()) || state.is((Block)BlockInit.ENRICHED_VIBRANIUM_FARMLAND.get());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return new ItemStack((ItemLike)ItemInit.HEART_SHAPED_HERB.get());
    }

    protected VoxelShape getShape(BlockState p_57291_, BlockGetter p_57292_, BlockPos p_57293_, CollisionContext p_57294_) {
        return switch ((Integer)p_57291_.getValue((Property)AGE)) {
            case 0 -> SHAPE_SAPLING;
            case 3 -> Shapes.block();
            default -> SHAPE_GROWING;
        };
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 3;
    }

    protected void randomTick(BlockState blockState, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        int i = (Integer)blockState.getValue((Property)AGE);
        if (i < 3 && serverLevel.getRawBrightness(pos.above(), 0) >= 9 && CommonHooks.canCropGrow((Level)serverLevel, (BlockPos)pos, (BlockState)blockState, (randomSource.nextInt(5) == 0 ? 1 : 0) != 0) && randomSource.nextInt(40) == 0) {
            BlockState blockstate = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i + 1));
            serverLevel.setBlock(pos, blockstate, 2);
            CommonHooks.fireCropGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)blockState);
            serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)blockstate));
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)AGE) == 3 && random.nextInt(20) == 0) {
            double offsetX = random.nextDouble() * 0.2 - 0.08;
            double offsetY = random.nextDouble() * 0.2 - 0.05;
            double offsetZ = random.nextDouble() * 0.2 - 0.08;
            double particleX = (double)pos.getX() + 0.5 + offsetX;
            double particleY = (double)pos.getY() + 0.45 + offsetY;
            double particleZ = (double)pos.getZ() + 0.5 + offsetZ;
            world.addParticle((ParticleOptions)ParticleInit.DRIPPING_VIBRANIUM.get(), particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }

    protected InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean flag;
        int i = (Integer)blockState.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (i > 1) {
            int j = 1 + level.random.nextInt(2);
            HSHBushBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ItemInit.HEART_SHAPED_HERB.get(), j + (flag ? 1 : 0)));
            level.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockstate = (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(1));
            level.setBlock(pos, blockstate, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockstate));
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(blockState, level, pos, player, hitResult);
    }

    public boolean isValidBonemealTarget(LevelReader world, BlockPos pos, BlockState state) {
        return false;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public void performBonemeal(ServerLevel p_220874_, RandomSource p_220875_, BlockPos p_220876_, BlockState p_220877_) {
    }
}

