/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.block.tree;

import de.bigbull.vibranium.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class SoulTreeSaplingBlock
extends SaplingBlock {
    public SoulTreeSaplingBlock(TreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(treeGrower, properties);
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        BlockPos groundPos = pos.below();
        BlockState groundState = level.getBlockState(groundPos);
        if (groundState.is((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())) {
            super.advanceTree(level, pos, state, random);
        }
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockPos groundPos;
        BlockState groundState;
        if (itemStack.is(Items.BONE_MEAL) && !(groundState = level.getBlockState(groundPos = pos.below())).is((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get())) {
            if (!level.isClientSide()) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5, (double)pos.getY() + 0.6, (double)pos.getZ() + 0.5, 5, 0.25, 0.25, 0.25, 0.0);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, pos, player, hand, blockHitResult);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        BlockPos groundPos = pos.below();
        BlockState groundState = level.getBlockState(groundPos);
        return groundState.is((Block)BlockInit.ENRICHED_VIBRANIUM_DIRT.get());
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.advanceTree(level, pos, state, random);
    }
}

