/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.block.vibraniumcrystal;

import com.mojang.serialization.MapCodec;
import de.bigbull.vibranium.init.BlockInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BuddingVibraniumBlock
extends AmethystBlock {
    public static final MapCodec<BuddingVibraniumBlock> CODEC = BuddingVibraniumBlock.simpleCodec(BuddingVibraniumBlock::new);
    public static final Direction[] DIRECTIONS = Direction.values();
    private static final int GROWTH_CHANCE = 5;

    public MapCodec<BuddingVibraniumBlock> codec() {
        return CODEC;
    }

    public BuddingVibraniumBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(5) == 0) {
            Direction direction = DIRECTIONS[random.nextInt(DIRECTIONS.length)];
            BlockPos adjacentPos = pos.relative(direction);
            BlockState adjacentState = level.getBlockState(adjacentPos);
            Block block = null;
            if (this.canClusterGrowAtState(adjacentState)) {
                block = (Block)BlockInit.SMALL_VIBRANIUM_BUD.get();
            } else if (adjacentState.is((Block)BlockInit.SMALL_VIBRANIUM_BUD.get()) && adjacentState.getValue((Property)BlockStateProperties.FACING) == direction) {
                block = (Block)BlockInit.MEDIUM_VIBRANIUM_BUD.get();
            } else if (adjacentState.is((Block)BlockInit.MEDIUM_VIBRANIUM_BUD.get()) && adjacentState.getValue((Property)BlockStateProperties.FACING) == direction) {
                block = (Block)BlockInit.LARGE_VIBRANIUM_BUD.get();
            } else if (adjacentState.is((Block)BlockInit.LARGE_VIBRANIUM_BUD.get()) && adjacentState.getValue((Property)BlockStateProperties.FACING) == direction) {
                block = (Block)BlockInit.VIBRANIUM_CLUSTER.get();
            }
            if (block != null) {
                BlockState newState = (BlockState)((BlockState)block.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(state.getFluidState().getType() == Fluids.WATER));
                level.setBlockAndUpdate(adjacentPos, newState);
            }
        }
    }

    private boolean canClusterGrowAtState(BlockState state) {
        return state.isAir() || state.is(Blocks.WATER) && state.getFluidState().getAmount() == 8;
    }
}

