/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.block.vibraniumcrystal;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VibraniumClusterBlock
extends AmethystBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<VibraniumClusterBlock> CODEC = RecordCodecBuilder.mapCodec(p_367977_ -> p_367977_.group((App)Codec.FLOAT.fieldOf("height").forGetter(p_304411_ -> Float.valueOf(p_304411_.height)), (App)Codec.FLOAT.fieldOf("aabb_offset").forGetter(p_304908_ -> Float.valueOf(p_304908_.aabbOffset)), (App)VibraniumClusterBlock.propertiesCodec()).apply((Applicative)p_367977_, VibraniumClusterBlock::new));
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    private final float height;
    private final float aabbOffset;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public MapCodec<VibraniumClusterBlock> codec() {
        return CODEC;
    }

    public VibraniumClusterBlock(float height, float aabbOffset, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue(FACING, (Comparable)Direction.UP));
        this.upAabb = Block.box((double)aabbOffset, (double)0.0, (double)aabbOffset, (double)(16.0f - aabbOffset), (double)height, (double)(16.0f - aabbOffset));
        this.downAabb = Block.box((double)aabbOffset, (double)(16.0f - height), (double)aabbOffset, (double)(16.0f - aabbOffset), (double)16.0, (double)(16.0f - aabbOffset));
        this.northAabb = Block.box((double)aabbOffset, (double)aabbOffset, (double)(16.0f - height), (double)(16.0f - aabbOffset), (double)(16.0f - aabbOffset), (double)16.0);
        this.southAabb = Block.box((double)aabbOffset, (double)aabbOffset, (double)0.0, (double)(16.0f - aabbOffset), (double)(16.0f - aabbOffset), (double)height);
        this.eastAabb = Block.box((double)0.0, (double)aabbOffset, (double)aabbOffset, (double)height, (double)(16.0f - aabbOffset), (double)(16.0f - aabbOffset));
        this.westAabb = Block.box((double)(16.0f - height), (double)aabbOffset, (double)aabbOffset, (double)16.0, (double)(16.0f - aabbOffset), (double)(16.0f - aabbOffset));
        this.height = height;
        this.aabbOffset = aabbOffset;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue(FACING);
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            case Direction.UP -> this.upAabb;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        Level levelaccessor = placeContext.getLevel();
        BlockPos blockpos = placeContext.getClickedPos();
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER))).setValue(FACING, (Comparable)placeContext.getClickedFace());
    }

    protected BlockState updateShape(BlockState blockState, LevelReader levelReader, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos blockPos, BlockState state, RandomSource randomSource) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(levelReader));
        }
        return direction == ((Direction)blockState.getValue(FACING)).getOpposite() && !blockState.canSurvive(levelReader, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(blockState, levelReader, tickAccess, pos, direction, blockPos, state, randomSource);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = ((Direction)state.getValue(FACING)).getOpposite();
        BlockPos blockPos = pos.relative(direction);
        return world.getBlockState(blockPos).isFaceSturdy((BlockGetter)world, blockPos, direction);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, FACING});
    }
}

