/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item;

import de.bigbull.vibranium.init.EffectInit;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.consume_effects.ApplyStatusEffectsConsumeEffect;
import net.minecraft.world.item.consume_effects.ConsumeEffect;

public class HSHPotionItems
extends Item {
    private final int duration;
    private final int amplifier;

    public HSHPotionItems(Item.Properties properties, int duration, int amplifier) {
        super(properties.component(DataComponents.CONSUMABLE, (Object)HSHPotionItems.createSoulHerbElixer(duration, amplifier)));
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public static Consumable createSoulHerbElixer(int duration, int amplifier) {
        return Consumable.builder().consumeSeconds(1.6f).animation(ItemUseAnimation.DRINK).sound((Holder)SoundEvents.GENERIC_DRINK).hasConsumeParticles(false).onConsume((ConsumeEffect)new ApplyStatusEffectsConsumeEffect(List.of(new MobEffectInstance(EffectInit.KINETIC_REDISTRIBUTION, duration, amplifier), new MobEffectInstance(MobEffects.REGENERATION, duration / 4, amplifier, false, false), new MobEffectInstance(MobEffects.ABSORPTION, duration / 4, amplifier, false, false), new MobEffectInstance(MobEffects.STRENGTH, duration / 4, amplifier, false, false), new MobEffectInstance(MobEffects.SPEED, duration / 4, amplifier, false, false)), 1.0f)).build();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        List<MobEffectInstance> effects = List.of(new MobEffectInstance(EffectInit.KINETIC_REDISTRIBUTION, this.duration, this.amplifier));
        PotionContents.addPotionTooltip(effects, consumer, (float)1.0f, (float)tooltipContext.tickRate());
    }
}

