/*
 * Decompiled with CFR 0.152.
 */
package de.bigbull.vibranium.init.custom.item;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VibraniumMaceItem
extends Item {
    private final ToolMaterial material;
    private float lastCalculatedDamage = 0.0f;
    public static final Component TOOLTIP = Component.translatable((String)"item.vibranium_mace.tooltip").withStyle(ChatFormatting.GRAY);

    public VibraniumMaceItem(ToolMaterial material, Item.Properties properties) {
        super(properties);
        this.material = material;
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 5.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-3.2f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public static Tool createToolProperties() {
        return new Tool(List.of(), 1.0f, 1, false);
    }

    public static List<BlockPos> getBlocksToBeDestroyed(int range, BlockPos initalBlockPos, Player player) {
        int y;
        int x;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockHitResult traceResult = player.level().clip(new ClipContext(player.getEyePosition(1.0f), player.getEyePosition(1.0f).add(player.getViewVector(1.0f).scale(6.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (traceResult.getType() == HitResult.Type.MISS) {
            return positions;
        }
        if (traceResult.getDirection() == Direction.DOWN || traceResult.getDirection() == Direction.UP) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY(), initalBlockPos.getZ() + y));
                }
            }
        }
        if (traceResult.getDirection() == Direction.NORTH || traceResult.getDirection() == Direction.SOUTH) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX() + x, initalBlockPos.getY() + y, initalBlockPos.getZ()));
                }
            }
        }
        if (traceResult.getDirection() == Direction.EAST || traceResult.getDirection() == Direction.WEST) {
            for (x = -range; x <= range; ++x) {
                for (y = -range; y <= range; ++y) {
                    positions.add(new BlockPos(initalBlockPos.getX(), initalBlockPos.getY() + y, initalBlockPos.getZ() + x));
                }
            }
        }
        return positions;
    }

    public void hurtEnemy(ItemStack itemStack, LivingEntity entity, LivingEntity entity1) {
        if (VibraniumMaceItem.canSmashAttack(entity1)) {
            ServerLevel serverlevel = (ServerLevel)entity1.level();
            entity1.setDeltaMovement(entity1.getDeltaMovement().with(Direction.Axis.Y, (double)0.01f));
            if (entity1 instanceof ServerPlayer) {
                ServerPlayer serverplayer = (ServerPlayer)entity1;
                serverplayer.currentImpulseImpactPos = this.calculateImpactPosition(serverplayer);
                serverplayer.setIgnoreFallDamageFromCurrentImpulse(true);
                serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
            }
            if (entity.onGround()) {
                if (entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayer1 = (ServerPlayer)entity1;
                    serverplayer1.setSpawnExtraParticlesOnFall(true);
                }
                SoundEvent soundevent = entity1.fallDistance > 5.0 ? SoundEvents.MACE_SMASH_GROUND_HEAVY : SoundEvents.MACE_SMASH_GROUND;
                serverlevel.playSound(null, entity1.getX(), entity1.getY(), entity1.getZ(), soundevent, entity1.getSoundSource(), 1.0f, 1.0f);
            } else {
                serverlevel.playSound(null, entity1.getX(), entity1.getY(), entity1.getZ(), SoundEvents.MACE_SMASH_AIR, entity1.getSoundSource(), 1.0f, 1.0f);
            }
            this.knockback((Level)serverlevel, (Entity)entity1, (Entity)entity);
        }
    }

    private Vec3 calculateImpactPosition(ServerPlayer p_365384_) {
        return p_365384_.isIgnoringFallDamageFromCurrentImpulse() && p_365384_.currentImpulseImpactPos != null && p_365384_.currentImpulseImpactPos.y <= p_365384_.position().y ? p_365384_.currentImpulseImpactPos : p_365384_.position();
    }

    public void postHurtEnemy(ItemStack itemStack, LivingEntity entity, LivingEntity entity1) {
        if (VibraniumMaceItem.canSmashAttack(entity1)) {
            entity1.resetFallDistance();
        }
    }

    public float getAttackDamageBonus(Entity entity, float v, DamageSource damageSource) {
        Entity entity2 = damageSource.getDirectEntity();
        if (entity2 instanceof LivingEntity) {
            float f;
            LivingEntity livingentity = (LivingEntity)entity2;
            if (!VibraniumMaceItem.canSmashAttack(livingentity)) {
                return 0.0f;
            }
            double f3 = 3.0;
            double f2 = 8.0;
            double f1 = livingentity.fallDistance;
            double damage = f1 <= 3.0 ? 4.0 * f1 : (f1 <= 8.0 ? 12.0 + 2.0 * (f1 - 3.0) : 22.0 + f1 - 8.0);
            this.lastCalculatedDamage = (float)damage;
            Level level = livingentity.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)level;
                f = (float)(damage + (double)EnchantmentHelper.modifyFallBasedDamage((ServerLevel)serverlevel, (ItemStack)livingentity.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)0.0f) * f1);
            } else {
                f = (float)damage;
            }
            return f;
        }
        this.lastCalculatedDamage = 0.0f;
        return 0.0f;
    }

    private void knockback(Level level, Entity entity, Entity entity1) {
        level.levelEvent(2013, entity1.getOnPos(), 750);
        level.getEntitiesOfClass(LivingEntity.class, entity1.getBoundingBox().inflate(3.5), VibraniumMaceItem.knockbackPredicate(entity, entity1)).forEach(target -> {
            Vec3 vec3 = target.position().subtract(entity1.position());
            double d0 = VibraniumMaceItem.getKnockbackPower(entity, target, vec3);
            Vec3 vec31 = vec3.normalize().scale(d0);
            if (d0 > 0.0) {
                target.push(vec31.x, (double)0.7f, vec31.z);
                if (this.lastCalculatedDamage > 0.0f) {
                    float pushDamage = this.lastCalculatedDamage / 6.0f;
                    target.hurtServer((ServerLevel)level, level.damageSources().mace(entity), pushDamage);
                }
                if (target instanceof ServerPlayer) {
                    ServerPlayer serverplayer = (ServerPlayer)target;
                    serverplayer.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)serverplayer));
                }
            }
        });
    }

    private static Predicate<LivingEntity> knockbackPredicate(Entity entity, Entity entity1) {
        return arg_0 -> VibraniumMaceItem.lambda$knockbackPredicate$1(entity, entity1, arg_0);
    }

    private static double getKnockbackPower(Entity entity, LivingEntity entity1, Vec3 vec3) {
        return (3.5 - vec3.length()) * (double)0.7f * (double)(entity.fallDistance > 5.0 ? 2 : 1) * (1.0 - entity1.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
    }

    public static boolean canSmashAttack(LivingEntity entity) {
        return entity.fallDistance > 1.5 && !entity.isFallFlying();
    }

    @Nullable
    public DamageSource getDamageSource(LivingEntity entity) {
        return VibraniumMaceItem.canSmashAttack(entity) ? entity.damageSources().mace((Entity)entity) : super.getDamageSource(entity);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        float baseSpeed = this.material.speed();
        if (state.is(BlockTags.MINEABLE_WITH_SHOVEL)) {
            return baseSpeed * 0.1005f;
        }
        if (state.is(BlockTags.MINEABLE_WITH_AXE)) {
            return baseSpeed * 0.3f;
        }
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return baseSpeed * 0.65f;
        }
        return baseSpeed;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag flag) {
        consumer.accept(TOOLTIP);
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ boolean lambda$knockbackPredicate$1(Entity entity, Entity entity1, LivingEntity p_393278_) {
        flag = p_393278_.isSpectator() == false;
        flag1 = p_393278_ != entity && p_393278_ != entity1;
        v0 = flag2 = entity.isAlliedTo((Entity)p_393278_) == false;
        if (!(p_393278_ instanceof TamableAnimal)) ** GOTO lbl-1000
        tamableanimal = (TamableAnimal)p_393278_;
        if (!(entity1 instanceof LivingEntity)) ** GOTO lbl-1000
        livingentity = (LivingEntity)entity1;
        if (tamableanimal.isTame() && tamableanimal.isOwnedBy(livingentity)) {
            v1 = true;
        } else lbl-1000:
        // 3 sources

        {
            v1 = false;
        }
        flag3 = v1 == false;
        flag4 = (p_393278_ instanceof ArmorStand != false && (armorstand = (ArmorStand)p_393278_).isMarker() != false) == false;
        flag5 = entity1.distanceToSqr((Entity)p_393278_) <= Math.pow(3.5, 2.0);
        return flag != false && flag1 != false && flag2 != false && flag3 != false && flag4 != false && flag5 != false;
    }
}

