/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.forcemaster_rpg.item.armor.Armors;
import net.forcemaster_rpg.item.tag.ModItemTags;
import net.forcemaster_rpg.item.weapons.WeaponsRegister;
import net.forcemaster_rpg.sounds.ModSounds;
import net.forcemaster_rpg.spell.ForcemasterSpells;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.spell_power.api.SpellPowerTags;

public class ForcemasterClassModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(SoundGen::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<HolderLookup.Provider> registriesFuture) {
            super(output, registriesFuture);
        }

        public void buildRecipes(RecipeOutput exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.orieneArmorSet, Items.LEATHER);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.phaslebArmorSet, Items.GOLD_NUGGET);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.akenArmorSet, Items.NETHERITE_SCRAP);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().getPath().contains("gold")).map(entry -> entry.item()).toList(), Items.GOLD_NUGGET);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().getPath().contains("iron")).map(entry -> entry.item()).toList(), Items.IRON_NUGGET);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().getPath().contains("netherite")).map(entry -> entry.item()).toList(), Items.NETHERITE_SCRAP);
        }

        private static void disassembleArmor(RecipeOutput exporter, Armor.Set armorSet, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, (List)armorSet.pieces(), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(RecipeOutput exporter, List<ItemLike> items, Item output) {
            FabricRecipeProvider.oreSmelting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.oreBlasting((RecipeOutput)exporter, items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void armorTags(List<Armor.Entry> armors) {
            this.armorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void armorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.armorTags(armors, EnumSet.of(metaType));
        }

        public void armorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            for (Armor.Entry armor : armors) {
                String lootTheme;
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder headTag = this.getOrCreateTagBuilder(ItemTags.HEAD_ARMOR);
                headTag.addOptional(set.idOf(set.head));
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(ItemTags.CHEST_ARMOR);
                chestTag.addOptional(set.idOf(set.chest));
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(ItemTags.LEG_ARMOR);
                legsTag.addOptional(set.idOf(set.legs));
                FabricTagProvider.FabricTagBuilder feetTag = this.getOrCreateTagBuilder(ItemTags.FOOT_ARMOR);
                feetTag.addOptional(set.idOf(set.feet));
                int tier = armor.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object id : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((ResourceLocation)id);
                    }
                }
                if ((lootTheme = armor.lootProperties().theme()) != null && !lootTheme.isEmpty()) {
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                    for (Object id : armor.armorSet().pieceIds()) {
                        themeTag.addOptional((ResourceLocation)id);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType metaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)metaType));
                    for (Object id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional((ResourceLocation)id);
                    }
                }
            }
        }

        public void generateKnuckleTags(List<Weapon.Entry> weapons) {
            for (Weapon.Entry weapon : weapons) {
                String lootTheme;
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(ModItemTags.KNUCKLES);
                tag.addOptional(weapon.id());
                int tier = weapon.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.WEAPONS));
                    tierTag.addOptional(weapon.id());
                }
                if ((lootTheme = weapon.lootProperties().theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                themeTag.addOptional(weapon.id());
            }
        }

        protected void addTags(HolderLookup.Provider wrapperLookup) {
            RPGSeriesDataGen.ItemTagGenerator.ArmorOptions armorTagOptions1 = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(false, true);
            RPGSeriesDataGen.ItemTagGenerator.ArmorOptions armorTagOptions2 = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(true, true);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("billporon")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC, armorTagOptions1);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> !entry.name().contains("billporon")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC, armorTagOptions2);
            this.generateKnuckleTags(WeaponsRegister.entries);
            FabricTagProvider.FabricTagBuilder spellInfinityTag = this.getOrCreateTagBuilder(SpellEngineItemTags.ENCHANTABLE_SPELL_INFINITY);
            spellInfinityTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder spellHasteTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.HASTE);
            spellHasteTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder criticalDamageTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_DAMAGE);
            criticalDamageTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder spellPowerTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.SPELL_POWER_GENERIC);
            spellPowerTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder unbreakingTag = this.getOrCreateTagBuilder(ItemTags.DURABILITY_ENCHANTABLE);
            unbreakingTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder sharpnessTag = this.getOrCreateTagBuilder(ItemTags.SHARP_WEAPON_ENCHANTABLE);
            sharpnessTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder meleeTag = this.getOrCreateTagBuilder(ItemTags.SWORDS);
            meleeTag.addTag(ModItemTags.KNUCKLES);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ForcemasterSpells.Entry entry : ForcemasterSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<HolderLookup.Provider> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("forcemaster_rpg", ModSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().getPath(), (int)entry.variants())).toList()));
        }
    }
}

