/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.effect;

import java.util.ArrayList;
import net.forcemaster_rpg.ForcemasterClassMod;
import net.forcemaster_rpg.config.EffectsConfig;
import net.forcemaster_rpg.effect.ArcaneOverflowEffect;
import net.forcemaster_rpg.effect.BarqEsnaEffect;
import net.forcemaster_rpg.effect.StoneHandEffect;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.more_rpg_classes.entity.attribute.MRPGCEntityAttributes;
import net.spell_engine.api.effect.Synchronized;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchools;

public class Effects {
    private static final ArrayList<Entry> entries = new ArrayList();
    public static final Entry STONE_HAND = new Entry("stone_hand", new StoneHandEffect(MobEffectCategory.BENEFICIAL, 12379646));
    public static final Entry ARCANE_OVERFLOW = new Entry("arcane_overflow", new ArcaneOverflowEffect(MobEffectCategory.BENEFICIAL, 16747503));
    public static final Entry BARQ_ESNA = new Entry("barq_esna", (MobEffect)new BarqEsnaEffect(MobEffectCategory.HARMFUL, 9286910).setVulnerability(SpellSchools.ARCANE, new SpellPower.Vulnerability(((EffectsConfig)ForcemasterClassMod.effectsConfig.value).barq_esna_arcane_damage_vulnerability, 0.1f, 0.2f)));

    public static void register() {
        Effects.STONE_HAND.effect.addAttributeModifier(Attributes.ATTACK_DAMAGE, STONE_HAND.modifierId(), (double)((EffectsConfig)ForcemasterClassMod.effectsConfig.value).stone_hand_attack_damage_increase, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.ARCANE_OVERFLOW.effect.addAttributeModifier(MRPGCEntityAttributes.ARCANE_FUSE_MODIFIER, ARCANE_OVERFLOW.modifierId(), (double)((EffectsConfig)ForcemasterClassMod.effectsConfig.value).arcane_overflow_arcane_fuse_multiply, AttributeModifier.Operation.ADD_MULTIPLIED_BASE).addAttributeModifier(SpellSchools.ARCANE.attributeEntry, ARCANE_OVERFLOW.modifierId(), (double)((EffectsConfig)ForcemasterClassMod.effectsConfig.value).arcane_overflow_arcane_spellpower_multiply, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Effects.BARQ_ESNA.effect.addAttributeModifier(Attributes.ATTACK_DAMAGE, BARQ_ESNA.modifierId(), (double)((EffectsConfig)ForcemasterClassMod.effectsConfig.value).barq_esna_attack_damage_reduction, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        Synchronized.configure((MobEffect)Effects.BARQ_ESNA.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.STONE_HAND.effect, (boolean)true);
        Synchronized.configure((MobEffect)Effects.ARCANE_OVERFLOW.effect, (boolean)true);
        for (Entry entry : entries) {
            entry.register();
        }
    }

    public static class Entry {
        public final ResourceLocation id;
        public final MobEffect effect;
        public Holder<MobEffect> registryEntry;

        public Entry(String name, MobEffect effect) {
            this.id = ResourceLocation.fromNamespaceAndPath((String)"forcemaster_rpg", (String)name);
            this.effect = effect;
            entries.add(this);
        }

        public void register() {
            this.registryEntry = Registry.registerForHolder((Registry)BuiltInRegistries.MOB_EFFECT, (ResourceLocation)this.id, (Object)this.effect);
        }

        public ResourceLocation modifierId() {
            return ResourceLocation.fromNamespaceAndPath((String)"forcemaster_rpg", (String)("effect." + this.id.getPath()));
        }
    }
}

