/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.mixin;

import java.util.Random;
import net.forcemaster_rpg.item.tag.ModItemTags;
import net.forcemaster_rpg.util.tags.FMEntityTypeTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.internals.casting.SpellCasterEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private int lastAttack = 0;

    @Inject(method={"setLastHurtMob(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")})
    private void onAttacking_knuckle(Entity target, CallbackInfo ci) {
        SpellCasterEntity caster;
        LivingEntity entity = (LivingEntity)this;
        ItemStack stack = entity.getItemBySlot(EquipmentSlot.MAINHAND);
        EntityType type = target.getType();
        if (target != null && stack.is(ModItemTags.KNUCKLES) && target instanceof LivingEntity && !target.isSpectator() && this.lastAttack != entity.tickCount && target.showVehicleHealth() && !type.is(FMEntityTypeTags.KNOCK_UP_IMMUNE) && entity instanceof SpellCasterEntity && !(caster = (SpellCasterEntity)entity).isCastingSpell()) {
            float knuckle_chance_knockup = 0.15f;
            float randomrange_knockup = new Random().nextFloat(1.0f);
            if (randomrange_knockup < knuckle_chance_knockup) {
                Vec3 currentMovement = target.getDeltaMovement();
                target.setDeltaMovement(currentMovement.x, currentMovement.y + 0.5, currentMovement.z);
                target.hurtMarked = true;
            }
        }
    }
}

