/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.spell;

import java.util.ArrayList;
import java.util.List;
import net.forcemaster_rpg.effect.Effects;
import net.minecraft.class_124;
import net.minecraft.class_2960;
import net.spell_engine.api.datagen.SpellBuilder;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.util.TriState;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.client.util.Color;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.internals.target.SpellTarget;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class ForcemasterSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static final Color ORANGE = new Color(255.0f, 165.0f, 0.0f);
    public static final Entry knuckle_knockup = ForcemasterSpells.add(ForcemasterSpells.knuckle_knockup());
    public static final Entry knuckle_arcane_overflow = ForcemasterSpells.add(ForcemasterSpells.knuckle_arcane_overflow());
    public static Entry stonehand = ForcemasterSpells.add(ForcemasterSpells.stonehand());
    public static Entry belial_smashing = ForcemasterSpells.add(ForcemasterSpells.belial_smashing());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        return spell;
    }

    private static Spell passiveSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.type = Spell.Type.PASSIVE;
        spell.passive = new Spell.Passive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = true;
        return spell;
    }

    private static Spell.Impact createEffectImpact(class_2960 effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static Spell.Impact createHeal(float coefficient) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.HEAL;
        buff.action.heal = new Spell.Impact.Action.Heal();
        buff.action.heal.spell_power_coefficient = coefficient;
        return buff;
    }

    private static Spell.Impact createDamage(float coefficient, float knockback) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.DAMAGE;
        buff.action.damage = new Spell.Impact.Action.Damage();
        buff.action.damage.spell_power_coefficient = coefficient;
        buff.action.damage.knockback = knockback;
        return buff;
    }

    private static Spell.Impact.TargetModifier createImpactModifier(String entityType) {
        Spell.TargetCondition condition = new Spell.TargetCondition();
        condition.entity_type = entityType;
        Spell.Impact.TargetModifier modifier = new Spell.Impact.TargetModifier();
        modifier.conditions = List.of(condition);
        return modifier;
    }

    private static void configureCooldown(Spell spell, float duration, float exhaust) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.exhaust = exhaust;
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static void stunImmuneDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = ForcemasterSpells.createImpactModifier("#more_rpg_classes:stun_immune");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static void bossDeny(Spell.Impact impact) {
        Spell.Impact.TargetModifier modifier = ForcemasterSpells.createImpactModifier("#c:bosses");
        modifier.execute = TriState.DENY;
        impact.target_modifiers = List.of(modifier);
    }

    private static Entry knuckle_knockup() {
        class_2960 id = class_2960.method_60655((String)"forcemaster_rpg", (String)"knuckle_knockup");
        String title = "Knuckle Knock Up";
        String description = "Hitting enemies has a {trigger_chance} chance to knock up the target.";
        Spell spell = SpellBuilder.createSpellPassive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = false;
        spell.school = ExternalSpellSchools.PHYSICAL_MELEE;
        spell.range = 0.0f;
        spell.target.type = Spell.Target.Type.FROM_TRIGGER;
        Spell.Trigger trigger = SpellBuilder.Triggers.meleeAttack((boolean)false);
        trigger.chance = 0.15f;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact custom = new Spell.Impact();
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        ForcemasterSpells.bossDeny(custom);
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HARMFUL;
        custom.action.custom.handler = "more_rpg_classes:knock_up_fixed";
        custom.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_medium.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.FEET, 20.0f, 0.1f, 0.3f).extent(0.25f).color(Color.WHITE.toRGBA())};
        spell.impacts = List.of(custom);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)4.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry knuckle_arcane_overflow() {
        class_2960 id = class_2960.method_60655((String)"forcemaster_rpg", (String)"knuckle_arcane_overflow");
        String title = "Arcane Overflow";
        String description = "Casting Forcemaster Spells stacks Arcane Overflow for {effect_duration} sec.";
        Effects.Entry effect = Effects.ARCANE_OVERFLOW;
        Spell spell = SpellBuilder.createSpellPassive();
        spell.tooltip = new Spell.Tooltip();
        spell.tooltip.show_header = false;
        spell.tooltip.name = new Spell.Tooltip.LineOptions(false, false);
        spell.tooltip.description.color = class_124.field_1077.method_15434();
        spell.tooltip.description.show_in_compact = false;
        spell.school = SpellSchools.ARCANE;
        spell.range = 0.0f;
        Spell.Trigger trigger = SpellBuilder.Triggers.activeSpellCast((SpellSchool)SpellSchools.ARCANE);
        trigger.target_override = Spell.Trigger.TargetSelector.CASTER;
        spell.passive.triggers = List.of(trigger);
        Spell.Impact impact = SpellBuilder.Impacts.effectAdd((String)effect.id.toString(), (float)15.0f, (int)1, (int)9);
        impact.action.status_effect.amplifier_cap_power_multiplier = 0.15f;
        impact.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.MagicParticles.get((SpellEngineParticles.MagicParticles.Shape)SpellEngineParticles.MagicParticles.Shape.ARCANE, (SpellEngineParticles.MagicParticles.Motion)SpellEngineParticles.MagicParticles.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 30.0f, 0.5f, 0.5f).color(Color.from((int)SpellSchools.ARCANE.color).toRGBA()), new ParticleBatch(SpellEngineParticles.aura_effect_642.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 1.0f, 0.0f, 0.0f).color(Color.from((int)SpellSchools.ARCANE.color).toRGBA())};
        spell.impacts = List.of(impact);
        SpellBuilder.Cost.cooldown((Spell)spell, (float)3.0f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry stonehand() {
        class_2960 id = class_2960.method_60655((String)"forcemaster_rpg", (String)"stonehand");
        Effects.Entry effect = Effects.STONE_HAND;
        String title = "Stonehand";
        String description = "";
        Spell spell = ForcemasterSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.tier = 1;
        spell.range = 2.0f;
        spell.release.animation = "forcemaster_rpg:stonehand_cast";
        spell.release.sound = Sound.withVolume((class_2960)class_2960.method_60654((String)"forcemaster_rpg:stonehand_cast"), (float)0.35f);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch("more_rpg_classes:stone_particle", ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 15.0f, 0.1f, 0.25f).extent(1.0f), new ParticleBatch(SpellEngineParticles.sign_fist.id().toString(), ParticleBatch.Shape.LINE_VERTICAL, ParticleBatch.Origin.CENTER, 1.0f, 0.75f, 0.75f).scale(1.2f).color(ORANGE.toRGBA()).followEntity(true)};
        spell.release.particles_scaled_with_ranged = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.area_effect_658.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.GROUND, 1.0f, 0.0f, 0.0f).color(ORANGE.toRGBA())};
        float stonehand_trigger_chance = 0.25f;
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        spell.deliver.stash_effect = new Spell.Delivery.StashEffect();
        spell.deliver.stash_effect.id = effect.id.toString();
        spell.deliver.stash_effect.consume = 0;
        Spell.Trigger trigger_melee = new Spell.Trigger();
        trigger_melee.chance = stonehand_trigger_chance;
        trigger_melee.type = Spell.Trigger.Type.MELEE_IMPACT;
        Spell.Trigger trigger_spell_impact = new Spell.Trigger();
        trigger_spell_impact.chance = stonehand_trigger_chance;
        trigger_spell_impact.type = Spell.Trigger.Type.SPELL_IMPACT_SPECIFIC;
        trigger_spell_impact.spell = new Spell.Trigger.SpellCondition();
        trigger_spell_impact.spell.type = Spell.Type.ACTIVE;
        trigger_spell_impact.impact = new Spell.Trigger.ImpactCondition();
        trigger_spell_impact.impact.impact_type = Spell.Impact.Action.Type.DAMAGE.toString();
        spell.deliver.stash_effect.triggers = List.of(trigger_melee, trigger_spell_impact);
        Spell.Impact custom = new Spell.Impact();
        ForcemasterSpells.stunImmuneDeny(custom);
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HARMFUL;
        custom.action.custom.handler = "forcemaster_rpg:fist_weapon_stun";
        spell.impacts = List.of(custom);
        ForcemasterSpells.configureCooldown(spell, 20.0f, 0.3f);
        return new Entry(id, spell, title, description, null);
    }

    private static Entry belial_smashing() {
        class_2960 id = class_2960.method_60655((String)"forcemaster_rpg", (String)"belial_smashing");
        Effects.Entry effect = Effects.ARCANE_OVERFLOW;
        String title = "Stonehand";
        String description = "";
        Spell spell = ForcemasterSpells.activeSpellBase();
        spell.school = SpellSchools.ARCANE;
        spell.tier = 3;
        spell.range = 8.5f;
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.target.aim.sticky = true;
        spell.release.animation = "forcemaster_rpg:fist_rush";
        spell.release.sound = Sound.withVolume((class_2960)class_2960.method_60654((String)"entity.generic.explode"), (float)0.35f);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 35.0f, 0.1f, 0.5f).followEntity(true).color(Color.WHITE.toRGBA())};
        Spell.Impact damage = SpellBuilder.Impacts.damage((float)0.75f, (float)0.5f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.smoke_large.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 15.0f, 0.1f, 0.3f).color(Color.WHITE.toRGBA())};
        damage.sound = new Sound("forcemaster_rpg:knuckle_attack");
        Spell.Impact damagePhysical = SpellBuilder.Impacts.damage((float)0.5f, (float)0.0f);
        damagePhysical.school = ExternalSpellSchools.PHYSICAL_MELEE;
        Spell.Impact buff = SpellBuilder.Impacts.effectAdd((String)effect.id.toString(), (float)10.0f, (int)1, (int)5);
        buff.action.status_effect.refresh_duration = true;
        Spell.Impact custom = new Spell.Impact();
        custom.action = new Spell.Impact.Action();
        custom.action.custom = new Spell.Impact.Action.Custom();
        custom.action.type = Spell.Impact.Action.Type.CUSTOM;
        custom.action.custom.intent = SpellTarget.Intent.HARMFUL;
        custom.action.custom.handler = "more_rpg_classes:rush_forward_to_target";
        spell.impacts = List.of(custom, damage, damagePhysical, buff);
        ForcemasterSpells.configureCooldown(spell, 22.0f, 0.5f);
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

