/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.client;

import java.util.List;
import java.util.function.Supplier;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRenderer;
import mod.azure.azurelibarmor.common.render.armor.AzArmorRendererRegistry;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.forcemaster_rpg.client.armor.CustomArmorRenderer;
import net.forcemaster_rpg.client.effect.ArcaneOverDriveRenderer;
import net.forcemaster_rpg.client.effect.BarqEsnaParticles;
import net.forcemaster_rpg.client.particle.Particles;
import net.forcemaster_rpg.client.particle.PunchParticle;
import net.forcemaster_rpg.compat.CompatLoadingCheck;
import net.forcemaster_rpg.effect.Effects;
import net.forcemaster_rpg.item.armor.Armors;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.more_rpg_classes.client.particle.CustomSpellExplosionParticle;
import net.more_rpg_classes.client.particle.GroundParticle;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.effect.CustomParticleStatusEffect;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.render.CustomModels;

public class ForcemasterClient {
    public static void init() {
        CustomModels.registerModelIds(List.of(ResourceLocation.fromNamespaceAndPath((String)"forcemaster_rpg", (String)"projectile/barqesna_projectile"), ResourceLocation.fromNamespaceAndPath((String)"forcemaster_rpg", (String)"projectile/fist_projectile"), ArcaneOverDriveRenderer.modelId));
        ForcemasterClient.registerArmorRenderer(Armors.orieneArmorSet, CustomArmorRenderer::oriene_armor);
        ForcemasterClient.registerArmorRenderer(Armors.phaslebArmorSet, CustomArmorRenderer::phasleb_armor);
        ForcemasterClient.registerArmorRenderer(Armors.akenArmorSet, CustomArmorRenderer::aken_armor);
        if (CompatLoadingCheck.armoryLoadCheck()) {
            ForcemasterClient.registerArmorRenderer(Armors.billporonArmorSet.armorSet(), CustomArmorRenderer::billporon_armor);
        }
        CustomParticleStatusEffect.register((MobEffect)Effects.BARQ_ESNA.effect, (CustomParticleStatusEffect.Spawner)new BarqEsnaParticles(1));
        CustomModelStatusEffect.register((MobEffect)Effects.ARCANE_OVERFLOW.effect, (CustomModelStatusEffect.Renderer)new ArcaneOverDriveRenderer());
    }

    public static void registerParticleAppearances() {
        ParticleFactoryRegistry registry = ParticleFactoryRegistry.getInstance();
        registry.register((ParticleType)Particles.ASAL_EXPLODE, HugeExplosionParticle.Provider::new);
        registry.register((ParticleType)Particles.BARQ_ESNA_FLAME, FlameParticle.Provider::new);
        registry.register((ParticleType)Particles.SONICHAND_VACUUM, CustomSpellExplosionParticle.Factory::new);
        registry.register((ParticleType)Particles.PUNCH, PunchParticle.Factory::new);
        registry.register((ParticleType)Particles.SONIC_PUNCH, PunchParticle.Factory::new);
        registry.register((ParticleType)Particles.GROUND_PUNCH, GroundParticle.DefaultFactory::new);
    }

    private static void registerArmorRenderer(Armor.Set set, Supplier<AzArmorRenderer> armorRendererSupplier) {
        AzArmorRendererRegistry.register(armorRendererSupplier, (Item)set.head, (Item[])new Item[]{set.chest, set.legs, set.feet});
    }
}

