/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg.item.weapons;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.forcemaster_rpg.ForcemasterClassMod;
import net.forcemaster_rpg.config.TweaksConfig;
import net.forcemaster_rpg.item.ForcemasterGroup;
import net.forcemaster_rpg.item.weapons.KnuckleItem;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.more_rpg_classes.custom.MoreSpellSchools;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.WeaponConfig;
import net.spell_engine.api.item.Equipment;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_power.api.SpellSchools;

public class WeaponsRegister {
    public static final ArrayList<Weapon.Entry> entries = new ArrayList();
    public static float knuckle_attackSpeed = -2.2f;
    private static final float T1_KNUCKLE_POWER = 3.0f;
    private static final float T2_KNUCKLE_POWER = 4.0f;
    private static final float T3_KNUCKLE_POWER = 5.0f;
    private static final float T4_KNUCKLE_POWER = 5.5f;
    public static final Weapon.Entry wooden_knuckle = WeaponsRegister.knuckle("wooden_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.WOOD, () -> Ingredient.of((TagKey)ItemTags.LOGS)), 2.0f).attribute(WeaponsRegister.armorAddition(1.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry stone_knuckle = WeaponsRegister.knuckle("stone_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.STONE, () -> Ingredient.of((TagKey)ItemTags.STONE_TOOL_MATERIALS)), 3.0f).attribute(WeaponsRegister.armorAddition(1.0f)).loot(Equipment.LootProperties.of((int)0));
    public static final Weapon.Entry iron_knuckle = WeaponsRegister.knuckle("iron_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.IRON_INGOT})), 4.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)3.0f)).attribute(WeaponsRegister.armorAddition(2.0f)).loot(Equipment.LootProperties.of((int)1));
    public static final Weapon.Entry golden_knuckle = WeaponsRegister.knuckle("golden_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT})), 2.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)3.0f)).attribute(WeaponsRegister.armorAddition(1.0f)).loot(Equipment.LootProperties.of((String)"golden_weapon"));
    public static final Weapon.Entry diamond_knuckle = WeaponsRegister.knuckle("diamond_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.DIAMOND, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.DIAMOND})), 5.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)4.0f)).attribute(WeaponsRegister.armorAddition(2.0f)).loot(Equipment.LootProperties.of((int)2));
    public static final Weapon.Entry netherite_knuckle = WeaponsRegister.knuckle("netherite_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT})), 5.5f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.0f)).attribute(WeaponsRegister.armorAddition(3.0f)).loot(Equipment.LootProperties.of((int)3));
    private static final String BETTER_END = "betterend";
    private static final String BETTER_NETHER = "betternether";
    private static final String AETHER = "aether";
    private static final String LNE = "loot_n_explore";
    private static final float lneWeaponSpellPower = 4.0f;

    private static AttributeModifier armorAddition(float value) {
        return new AttributeModifier("generic.armor", value, AttributeModifier.Operation.ADD_VALUE);
    }

    private static Weapon.Entry entry(String name, Weapon.CustomMaterial material, Weapon.Factory factory, WeaponConfig defaults, Equipment.WeaponType category) {
        Weapon.Entry entry = new Weapon.Entry("forcemaster_rpg", name, material, factory, defaults, category);
        if (entry.isRequiredModInstalled()) {
            entries.add(entry);
        }
        return entry;
    }

    private static Supplier<Ingredient> ingredient(String idString, boolean requirement, Item fallback) {
        ResourceLocation id = ResourceLocation.parse((String)idString);
        if (requirement) {
            return () -> Ingredient.of((ItemLike[])new ItemLike[]{fallback});
        }
        return () -> {
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            Item ingredient = item != null ? item : fallback;
            return Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        };
    }

    private static Weapon.Entry knuckle(String name, Weapon.CustomMaterial material, float damage) {
        return WeaponsRegister.entry(name, material, KnuckleItem::new, new WeaponConfig(damage, knuckle_attackSpeed), Equipment.WeaponType.SWORD);
    }

    public static void register(Map<String, WeaponConfig> configs) {
        Supplier<Ingredient> repair;
        if (FabricLoader.getInstance().isModLoaded(BETTER_NETHER) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betternether:nether_ruby", FabricLoader.getInstance().isModLoaded(BETTER_NETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.knuckle("ruby_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute(WeaponsRegister.armorAddition(3.0f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(BETTER_END) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("betterend:aeternium_ingot", FabricLoader.getInstance().isModLoaded(BETTER_END), Items.NETHERITE_INGOT);
            WeaponsRegister.knuckle("aeternium_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute(WeaponsRegister.armorAddition(3.0f)).loot(Equipment.LootProperties.of((int)4));
        }
        if (FabricLoader.getInstance().isModLoaded(AETHER) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            repair = WeaponsRegister.ingredient("aether:ambrosium_shard", FabricLoader.getInstance().isModLoaded(AETHER), Items.NETHERITE_INGOT);
            WeaponsRegister.knuckle("aether_knuckle", Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, repair), 7.0f).attribute(AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute(WeaponsRegister.armorAddition(3.0f)).loot(Equipment.LootProperties.of((String)AETHER));
        }
        if (FabricLoader.getInstance().isModLoaded(LNE) || ((TweaksConfig)ForcemasterClassMod.tweaksConfig.value).ignore_items_required_mods) {
            WeaponsRegister.knuckle((String)"ender_dragon_knuckle", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$8(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)7.0f).attribute((AttributeModifier)WeaponsRegister.armorAddition((float)3.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).rarity = Rarity.RARE;
            WeaponsRegister.knuckle((String)"elder_guardian_knuckle", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$9(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)7.0f).attribute((AttributeModifier)WeaponsRegister.armorAddition((float)3.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)MoreSpellSchools.WATER.id, (float)4.0f)).rarity = Rarity.RARE;
            WeaponsRegister.knuckle((String)"wither_knuckle", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$10(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)7.0f).attribute((AttributeModifier)WeaponsRegister.armorAddition((float)3.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.SOUL.id, (float)4.0f)).rarity = Rarity.RARE;
            WeaponsRegister.knuckle((String)"glacial_knuckle", (Weapon.CustomMaterial)Weapon.CustomMaterial.matching((Tiers)Tiers.NETHERITE, (Supplier<Ingredient>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$register$11(), ()Lnet/minecraft/world/item/crafting/Ingredient;)()), (float)7.0f).attribute((AttributeModifier)WeaponsRegister.armorAddition((float)3.0f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.ARCANE.id, (float)5.5f)).attribute((AttributeModifier)AttributeModifier.bonus((ResourceLocation)SpellSchools.FROST.id, (float)4.0f)).rarity = Rarity.RARE;
        }
        Weapon.register(configs, entries, ForcemasterGroup.FORCEMASTER_KEY);
    }

    private static /* synthetic */ Ingredient lambda$register$11() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.ICE});
    }

    private static /* synthetic */ Ingredient lambda$register$10() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.BONE});
    }

    private static /* synthetic */ Ingredient lambda$register$9() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.PRISMARINE_SHARD});
    }

    private static /* synthetic */ Ingredient lambda$register$8() {
        return Ingredient.of((ItemLike[])new ItemLike[]{Items.AMETHYST_SHARD});
    }
}

