/*
 * Decompiled with CFR 0.152.
 */
package net.forcemaster_rpg;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.forcemaster_rpg.item.armor.Armors;
import net.forcemaster_rpg.item.tag.ModItemTags;
import net.forcemaster_rpg.item.weapons.WeaponsRegister;
import net.forcemaster_rpg.sounds.ModSounds;
import net.forcemaster_rpg.spell.ForcemasterSpells;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import net.spell_engine.api.datagen.SimpleSoundGeneratorV2;
import net.spell_engine.api.datagen.SpellGenerator;
import net.spell_engine.api.item.armor.Armor;
import net.spell_engine.api.item.weapon.Weapon;
import net.spell_engine.api.tags.SpellEngineItemTags;
import net.spell_engine.rpg_series.datagen.RPGSeriesDataGen;
import net.spell_engine.rpg_series.tags.RPGSeriesItemTags;
import net.spell_power.api.SpellPowerTags;

public class ForcemasterClassModDataGenerator
implements DataGeneratorEntrypoint {
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(ItemTagGenerator::new);
        pack.addProvider(UnsmeltGenerator::new);
        pack.addProvider(SpellGen::new);
        pack.addProvider(SoundGen::new);
    }

    public static class UnsmeltGenerator
    extends FabricRecipeProvider {
        public static int UNSMELT_TIME = 300;

        public UnsmeltGenerator(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
            super(output, registriesFuture);
        }

        public void method_10419(class_8790 exporter) {
            UnsmeltGenerator.disassembleArmor(exporter, Armors.orieneArmorSet, class_1802.field_8745);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.phaslebArmorSet, class_1802.field_8397);
            UnsmeltGenerator.disassembleArmor(exporter, Armors.akenArmorSet, class_1802.field_22021);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().method_12832().contains("gold")).map(entry -> entry.item()).toList(), class_1802.field_8397);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().method_12832().contains("iron")).map(entry -> entry.item()).toList(), class_1802.field_8675);
            UnsmeltGenerator.disassemble(exporter, WeaponsRegister.entries.stream().filter(entry -> entry.id().method_12832().contains("netherite")).map(entry -> entry.item()).toList(), class_1802.field_22021);
        }

        private static void disassembleArmor(class_8790 exporter, Armor.Set armorSet, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, (List)armorSet.pieces(), (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }

        private static void disassemble(class_8790 exporter, List<class_1935> items, class_1792 output) {
            FabricRecipeProvider.method_36233((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)UNSMELT_TIME, (String)"disassemble");
            FabricRecipeProvider.method_36234((class_8790)exporter, items, (class_7800)class_7800.field_40642, (class_1935)output, (float)0.1f, (int)(UNSMELT_TIME / 2), (String)"disassemble");
        }
    }

    public static class ItemTagGenerator
    extends RPGSeriesDataGen.ItemTagGenerator {
        public ItemTagGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void armorTags(List<Armor.Entry> armors) {
            this.armorTags(armors, EnumSet.noneOf(RPGSeriesItemTags.ArmorMetaType.class));
        }

        public void armorTags(List<Armor.Entry> armors, RPGSeriesItemTags.ArmorMetaType metaType) {
            this.armorTags(armors, EnumSet.of(metaType));
        }

        public void armorTags(List<Armor.Entry> armors, EnumSet<RPGSeriesItemTags.ArmorMetaType> metaTypes) {
            for (Armor.Entry armor : armors) {
                String lootTheme;
                Armor.Set set = armor.armorSet();
                FabricTagProvider.FabricTagBuilder headTag = this.getOrCreateTagBuilder(class_3489.field_48297);
                headTag.addOptional(set.idOf(set.head));
                FabricTagProvider.FabricTagBuilder chestTag = this.getOrCreateTagBuilder(class_3489.field_48296);
                chestTag.addOptional(set.idOf(set.chest));
                FabricTagProvider.FabricTagBuilder legsTag = this.getOrCreateTagBuilder(class_3489.field_48295);
                legsTag.addOptional(set.idOf(set.legs));
                FabricTagProvider.FabricTagBuilder feetTag = this.getOrCreateTagBuilder(class_3489.field_48294);
                feetTag.addOptional(set.idOf(set.feet));
                int tier = armor.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.ARMORS));
                    for (Object id : armor.armorSet().pieceIds()) {
                        tierTag.addOptional((class_2960)id);
                    }
                }
                if ((lootTheme = armor.lootProperties().theme()) != null && !lootTheme.isEmpty()) {
                    FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                    for (Object id : armor.armorSet().pieceIds()) {
                        themeTag.addOptional((class_2960)id);
                    }
                }
                for (RPGSeriesItemTags.ArmorMetaType metaType : metaTypes) {
                    FabricTagProvider.FabricTagBuilder metaTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.ArmorType.get((RPGSeriesItemTags.ArmorMetaType)metaType));
                    for (Object id : armor.armorSet().pieceIds()) {
                        metaTag.addOptional((class_2960)id);
                    }
                }
            }
        }

        public void generateKnuckleTags(List<Weapon.Entry> weapons) {
            for (Weapon.Entry weapon : weapons) {
                String lootTheme;
                FabricTagProvider.FabricTagBuilder tag = this.getOrCreateTagBuilder(ModItemTags.KNUCKLES);
                tag.addOptional(weapon.id());
                int tier = weapon.lootProperties().tier();
                if (tier >= 0) {
                    FabricTagProvider.FabricTagBuilder tierTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootTiers.get((int)tier, (RPGSeriesItemTags.LootCategory)RPGSeriesItemTags.LootCategory.WEAPONS));
                    tierTag.addOptional(weapon.id());
                }
                if ((lootTheme = weapon.lootProperties().theme()) == null || lootTheme.isEmpty()) continue;
                FabricTagProvider.FabricTagBuilder themeTag = this.getOrCreateTagBuilder(RPGSeriesItemTags.LootThemes.get((String)lootTheme));
                themeTag.addOptional(weapon.id());
            }
        }

        protected void method_10514(class_7225.class_7874 wrapperLookup) {
            RPGSeriesDataGen.ItemTagGenerator.ArmorOptions armorTagOptions1 = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(false, true);
            RPGSeriesDataGen.ItemTagGenerator.ArmorOptions armorTagOptions2 = new RPGSeriesDataGen.ItemTagGenerator.ArmorOptions(true, true);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> entry.name().contains("billporon")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC, armorTagOptions1);
            this.generateArmorTags(Armors.entries.stream().filter(entry -> !entry.name().contains("billporon")).toList(), RPGSeriesItemTags.ArmorMetaType.MAGIC, armorTagOptions2);
            this.generateKnuckleTags(WeaponsRegister.entries);
            FabricTagProvider.FabricTagBuilder spellInfinityTag = this.getOrCreateTagBuilder(SpellEngineItemTags.ENCHANTABLE_SPELL_INFINITY);
            spellInfinityTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder spellHasteTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.HASTE);
            spellHasteTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder criticalDamageTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.CRITICAL_DAMAGE);
            criticalDamageTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder spellPowerTag = this.getOrCreateTagBuilder(SpellPowerTags.Items.Enchantable.SPELL_POWER_GENERIC);
            spellPowerTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder unbreakingTag = this.getOrCreateTagBuilder(class_3489.field_48310);
            unbreakingTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder sharpnessTag = this.getOrCreateTagBuilder(class_3489.field_50108);
            sharpnessTag.addTag(ModItemTags.KNUCKLES);
            FabricTagProvider.FabricTagBuilder meleeTag = this.getOrCreateTagBuilder(class_3489.field_42611);
            meleeTag.addTag(ModItemTags.KNUCKLES);
        }
    }

    public static class SpellGen
    extends SpellGenerator {
        public SpellGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSpells(SpellGenerator.Builder builder) {
            for (ForcemasterSpells.Entry entry : ForcemasterSpells.entries) {
                builder.add(entry.id(), entry.spell());
            }
        }
    }

    public static class SoundGen
    extends SimpleSoundGeneratorV2 {
        public SoundGen(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }

        public void generateSounds(SimpleSoundGeneratorV2.Builder builder) {
            builder.entries.add(new SimpleSoundGeneratorV2.Entry("forcemaster_rpg", ModSounds.entries.stream().map(entry -> SimpleSoundGeneratorV2.SoundEntry.withVariants((String)entry.id().method_12832(), (int)entry.variants())).toList()));
        }
    }
}

