/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesLeavesBlock;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.block.entity.renderer.TreeSimulatorBlockEntityRenderer;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.EssenceItem;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="resourcestrees", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ResourcesTreesClient {
    @SubscribeEvent
    public static void onFMLClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.register(ModMenuTypes.TREE_SIMULATOR.get(), TreeSimulatorScreen::new));
    }

    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, i) -> {
            BlockEntity blockEntity;
            if (blockAndTintGetter != null && (blockEntity = blockAndTintGetter.getBlockEntity(blockPos)) instanceof ResourcesTypesBlockEntity) {
                ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
                return be.getColor();
            }
            return -12012264;
        }, new Block[]{(Block)ModBlocks.RESOURCES_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), (Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), (Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), (Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), (Block)ModBlocks.RESOURCES_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), (Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), (Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), (Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get()});
    }

    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, i) -> {
            Item patt4167$temp;
            if (itemStack.hasTag() && itemStack.getTag().contains("type")) {
                ResourceLocation type = new ResourceLocation(itemStack.getTag().getString("type"));
                if (Block.byItem((Item)itemStack.getItem()) instanceof ResourcesSaplingBlock && i == 1 || Block.byItem((Item)itemStack.getItem()) instanceof ResourcesLeavesBlock || itemStack.getItem() instanceof LeafFragmentItem) {
                    try {
                        return ((ResourcesTypes)ResourcesTypes.asHolder((Level)Minecraft.getInstance().level, type).value()).color();
                    }
                    catch (Exception ignored) {
                        return -1;
                    }
                }
            }
            if ((patt4167$temp = itemStack.getItem()) instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)patt4167$temp;
                return essenceItem.getColor();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModBlocks.RESOURCES_OAK_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_OAK_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_CHERRY_LEAVES.get(), (ItemLike)ModItems.LEAF_FRAGMENT.get(), (ItemLike)ModItems.FIRE_ESSENCE.get(), (ItemLike)ModItems.WATER_ESSENCE.get(), (ItemLike)ModItems.NATURE_ESSENCE.get(), (ItemLike)ModItems.END_ESSENCE.get()});
    }

    @SubscribeEvent
    public static void onEntityRenderersRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.TREE_SIMULATOR_BE.get(), TreeSimulatorBlockEntityRenderer::new);
    }
}

