/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.custom.ResourcesLeavesBlock;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.custom.TreeSimulatorBlock;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.ModBlockItem;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.grower.AcaciaTreeGrower;
import net.minecraft.world.level.block.grower.BirchTreeGrower;
import net.minecraft.world.level.block.grower.CherryTreeGrower;
import net.minecraft.world.level.block.grower.DarkOakTreeGrower;
import net.minecraft.world.level.block.grower.JungleTreeGrower;
import net.minecraft.world.level.block.grower.OakTreeGrower;
import net.minecraft.world.level.block.grower.SpruceTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"resourcestrees");
    public static final RegistryObject<TreeSimulatorBlock> TREE_SIMULATOR = ModBlocks.registerBlock("tree_simulator", TreeSimulatorBlock::new, BlockBehaviour.Properties.of());
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_OAK_SAPLING = ModBlocks.registerBlock("resources_oak_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new OakTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_oak_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_OAK_LEAVES = ModBlocks.registerBlock("resources_oak_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_OAK_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.OAK_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_SPRUCE_SAPLING = ModBlocks.registerBlock("resources_spruce_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new SpruceTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_spruce_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.SPRUCE_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_SPRUCE_LEAVES = ModBlocks.registerBlock("resources_spruce_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_SPRUCE_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.SPRUCE_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_BIRCH_SAPLING = ModBlocks.registerBlock("resources_birch_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new BirchTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_birch_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.BIRCH_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_BIRCH_LEAVES = ModBlocks.registerBlock("resources_birch_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_BIRCH_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.BIRCH_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_JUNGLE_SAPLING = ModBlocks.registerBlock("resources_jungle_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new JungleTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_jungle_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.JUNGLE_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_JUNGLE_LEAVES = ModBlocks.registerBlock("resources_jungle_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_JUNGLE_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.JUNGLE_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_ACACIA_SAPLING = ModBlocks.registerBlock("resources_acacia_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new AcaciaTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_acacia_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.ACACIA_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_ACACIA_LEAVES = ModBlocks.registerBlock("resources_acacia_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_ACACIA_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.ACACIA_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_DARK_OAK_SAPLING = ModBlocks.registerBlock("resources_dark_oak_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new DarkOakTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_dark_oak_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.DARK_OAK_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_DARK_OAK_LEAVES = ModBlocks.registerBlock("resources_dark_oak_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_DARK_OAK_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.DARK_OAK_LEAVES));
    public static final RegistryObject<ResourcesSaplingBlock> RESOURCES_CHERRY_SAPLING = ModBlocks.registerBlock("resources_cherry_sapling", properties -> new ResourcesSaplingBlock((AbstractTreeGrower)new CherryTreeGrower(), (BlockBehaviour.Properties)properties, ResourcesTrees.id("resources_cherry_leaves")), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.CHERRY_SAPLING));
    public static final RegistryObject<ResourcesLeavesBlock> RESOURCES_CHERRY_LEAVES = ModBlocks.registerBlock("resources_cherry_leaves", properties -> new ResourcesLeavesBlock((BlockBehaviour.Properties)properties, (Supplier<ResourcesSaplingBlock>)RESOURCES_CHERRY_SAPLING), BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.CHERRY_LEAVES));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Function<BlockBehaviour.Properties, ? extends T> func, BlockBehaviour.Properties properties) {
        RegistryObject block = BLOCKS.register(name, () -> (Block)func.apply(properties));
        ModBlocks.registerBlockItem(name, block);
        return block;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new ModBlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

