/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.custom;

import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ResourcesLeavesBlock
extends LeavesBlock
implements EntityBlock {
    private final Supplier<ResourcesSaplingBlock> sapling;

    public ResourcesLeavesBlock(BlockBehaviour.Properties properties, Supplier<ResourcesSaplingBlock> sapling) {
        super(properties);
        this.sapling = sapling;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        Vec3 pos = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            this.calculateDrops(be, builder, drops);
        } else {
            BlockEntity blockEntity2 = builder.getLevel().getBlockEntity(new BlockPos((int)pos.x, (int)pos.y, (int)pos.z));
            if (blockEntity2 instanceof ResourcesTypesBlockEntity) {
                ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity2;
                this.calculateDrops(be, builder, drops);
            }
        }
        return drops;
    }

    private void calculateDrops(ResourcesTypesBlockEntity be, LootParams.Builder builder, List<ItemStack> drops) {
        ResourceLocation type = be.getResourcesType();
        ResourcesTypes resourcesTypes = (ResourcesTypes)ResourcesTypes.asHolder((Level)builder.getLevel(), type).value();
        if (drops.isEmpty()) {
            CompoundTag tag;
            if (builder.getLevel().getRandom().nextFloat() < resourcesTypes.saplingDropChance()) {
                ItemStack saplingDrop = this.sapling.get().asItem().getDefaultInstance();
                tag = saplingDrop.getOrCreateTag();
                tag.putString("type", type.toString());
                drops.add(saplingDrop);
            }
            ItemStack fragment = ((LeafFragmentItem)((Object)ModItems.LEAF_FRAGMENT.get())).getDefaultInstance();
            tag = fragment.getOrCreateTag();
            tag.putString("type", type.toString());
            drops.add(fragment.copy());
            if (builder.getLevel().getRandom().nextFloat() < resourcesTypes.leafDropChance()) {
                drops.add(fragment.copy());
            }
            if (builder.getLevel().getRandom().nextFloat() < resourcesTypes.leafDropChance() / 2.0f) {
                drops.add(fragment.copy());
            }
        } else if (Block.byItem((Item)drops.get(0).getItem()) instanceof ResourcesLeavesBlock) {
            drops.get(0).getOrCreateTag().putString("type", type.toString());
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (stack.hasTag() && stack.getTag().contains("type")) {
                be.setResourcesType(new ResourceLocation(stack.getTag().getString("type")));
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
            stack.getOrCreateTag().putString("type", be.getResourcesType().toString());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ResourcesTypesBlockEntity(blockPos, blockState);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (this.decaying(state)) {
            List<ItemStack> drops = this.getDrops(state, new LootParams.Builder(level).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)level.getBlockEntity(pos)).withParameter(LootContextParams.ORIGIN, (Object)pos.getCenter()));
            drops.forEach(drop -> level.addFreshEntity((Entity)new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), drop)));
            level.removeBlock(pos, false);
        }
    }
}

