/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.custom;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datagen.ModRecipeProvider;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeSimulatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final Map<ResourcesSaplingBlock, Item> LOG_BY_SAPLINGS = Map.of((ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_OAK_SAPLING.get()), Items.OAK_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_SPRUCE_SAPLING.get()), Items.SPRUCE_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_BIRCH_SAPLING.get()), Items.BIRCH_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_JUNGLE_SAPLING.get()), Items.JUNGLE_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_ACACIA_SAPLING.get()), Items.ACACIA_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get()), Items.DARK_OAK_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_CHERRY_SAPLING.get()), Items.CHERRY_LOG);
    public int growTicks = 0;
    public int maxGrowTicks = 0;
    private final ItemStackHandler inputHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            Optional<TreeSimulatorRecipe> recipeHolder = TreeSimulatorBlockEntity.this.getCurrentRecipe();
            if (recipeHolder.isPresent()) {
                TreeSimulatorRecipe recipe = recipeHolder.get();
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(recipe.ticksToGrow());
            } else {
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(0);
            }
        }
    };
    private final ItemStackHandler outputHandler = new ItemStackHandler(9);
    private final ItemStackHandler axeHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() instanceof AxeItem;
        }
    };
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> TreeSimulatorBlockEntity.this.growTicks;
                case 1 -> TreeSimulatorBlockEntity.this.maxGrowTicks;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    TreeSimulatorBlockEntity.this.growTicks = value;
                    break;
                }
                case 1: {
                    TreeSimulatorBlockEntity.this.maxGrowTicks = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public TreeSimulatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.TREE_SIMULATOR_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Tree Simulator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new TreeSimulatorMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("input", (Tag)this.inputHandler.serializeNBT());
        tag.put("output", (Tag)this.outputHandler.serializeNBT());
        tag.put("axe", (Tag)this.axeHandler.serializeNBT());
        tag.putInt("growTicks", this.growTicks);
        tag.putInt("maxGrowTicks", this.maxGrowTicks);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.inputHandler.deserializeNBT(tag.getCompound("input"));
        this.outputHandler.deserializeNBT(tag.getCompound("output"));
        this.axeHandler.deserializeNBT(tag.getCompound("axe"));
        this.data.set(0, tag.getInt("growTicks"));
        this.data.set(1, tag.getInt("maxGrowTicks"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.load(tag);
    }

    public CompoundTag getUpdateTag() {
        CompoundTag tag = this.saveWithoutMetadata();
        tag.putInt("growTicks", this.growTicks);
        tag.putInt("maxGrowTicks", this.maxGrowTicks);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.load(pkt.getTag());
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.isAxeValid()) {
            this.increaseGrowTicks();
            TreeSimulatorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.treeGrown()) {
                this.harvest(level);
                this.resetGrowTicks();
            }
        } else {
            this.resetGrowTicks();
        }
        this.setChanged();
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    private void harvest(Level level) {
        Optional<TreeSimulatorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ArrayList results = new ArrayList();
            recipe.get().drops().forEach(output -> {
                int rolls = output.getRolls(level.random);
                for (int i = 0; i < rolls; ++i) {
                    if (!(level.random.nextFloat() < output.chance())) continue;
                    results.add(output.output().copy());
                }
            });
            if (!this.isAxeUnbreakable()) {
                ItemStack axe = this.getAxe();
                int damage = axe.getDamageValue();
                axe.setDamageValue(damage + 1);
            }
            for (ItemStack result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.insertItem(outputSlot, result, false);
                    continue;
                }
                ResourcesTrees.LOGGER.warn("No suitable output slot found for item: {} at {}", (Object)result, (Object)this.getBlockPos());
            }
        }
    }

    private boolean treeGrown() {
        return this.growTicks >= this.maxGrowTicks;
    }

    private void increaseGrowTicks() {
        ++this.growTicks;
    }

    private void resetGrowTicks() {
        this.growTicks = 0;
    }

    private void setMaxGrowTicks(int tick) {
        this.data.set(1, tick);
    }

    private int findSuitableOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<TreeSimulatorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        List<ItemStack> results = recipe.get().drops().stream().map(TreeSimulatorOutput::output).toList();
        for (ItemStack result : results) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result)) continue;
            return false;
        }
        return this.checkSlot(results);
    }

    private boolean checkSlot(List<ItemStack> results) {
        int count = results.size();
        int emptyCount = 0;
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty()) {
                for (ItemStack result : results) {
                    if (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack item) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && !ResourcesTypes.isSameItemSameType(stackInSlot, item)) continue;
            return true;
        }
        return false;
    }

    private Optional<TreeSimulatorRecipe> getCurrentRecipe() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional recipe = serverLevel.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get(), (Container)new TreeSimulatorRecipeInput(this.getSapling()), (Level)serverLevel);
            if (recipe.isPresent()) {
                return recipe;
            }
            Block block = Block.byItem((Item)this.getSapling().getItem());
            if (block instanceof ResourcesSaplingBlock) {
                ResourcesSaplingBlock block2 = (ResourcesSaplingBlock)block;
                if (this.getSapling().hasTag() && this.getSapling().getTag().contains("type")) {
                    ResourceLocation type = new ResourceLocation(this.getSapling().getTag().getString("type"));
                    Holder<ResourcesTypes> value = ResourcesTypes.asHolder((Level)serverLevel, type);
                    ItemStack leaf = ((LeafFragmentItem)((Object)ModItems.LEAF_FRAGMENT.get())).getDefaultInstance();
                    leaf.getOrCreateTag().putString("type", type.toString());
                    if (value != null && value.value() != ResourcesTypes.EMPTY) {
                        ArrayList<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
                        drops.add(TreeSimulatorOutput.of(LOG_BY_SAPLINGS.get((Object)block2).getDefaultInstance(), 1.0f, 2, 4));
                        drops.add(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1));
                        drops.add(TreeSimulatorOutput.of(leaf, ((ResourcesTypes)value.value()).leafDropChance(), 1, 1));
                        drops.add(TreeSimulatorOutput.of(this.getSapling(), ((ResourcesTypes)value.value()).saplingDropChance(), 1, 1));
                        drops.add(TreeSimulatorOutput.of(Items.STICK.getDefaultInstance(), 0.1f, 1, 2));
                        drops.add(TreeSimulatorOutput.of(Items.APPLE.getDefaultInstance(), 0.05f, 1, 1));
                        drops.add(TreeSimulatorOutput.of(ModRecipeProvider.SAPLINGS_BY_SAPLINGS.get((Object)block2).getDefaultInstance(), 0.1f, 1, 1));
                        TreeSimulatorRecipe newRecipe = new TreeSimulatorRecipe(this.getSapling(), drops, 1200, type.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)block2).getPath().substring(9)).withPrefix("tree_simulator/"));
                        return Optional.of(newRecipe);
                    }
                }
            }
        }
        return Optional.empty();
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ItemStack getSapling() {
        return this.inputHandler.getStackInSlot(0);
    }

    public ContainerData getData() {
        return this.data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.outputHandler).cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getAxeHandler() {
        return this.axeHandler;
    }

    public ItemStack getAxe() {
        return this.axeHandler.getStackInSlot(0);
    }

    public boolean isAxeUnbreakable() {
        return this.getAxe().hasTag() && this.getAxe().getTag().contains("Unbreakable") || this.getAxe().getMaxDamage() == 0 && this.getAxe() != ItemStack.EMPTY;
    }

    public boolean isAxeValid() {
        int maxDamage;
        ItemStack axe = this.getAxe();
        int damage = axe.getDamageValue();
        if (damage >= (maxDamage = axe.getMaxDamage()) && axe != ItemStack.EMPTY) {
            this.axeHandler.extractItem(0, 1, false);
        }
        return damage < maxDamage || this.isAxeUnbreakable();
    }
}

