/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.custom.TreeSimulatorBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datagen.recipebuilder.ShapedRecipeNBTOutputBuilder;
import com.coolerpromc.resourcestrees.datagen.recipebuilder.TreeSimulatorRecipeBuilder;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.registry.ModRegistries;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.PartialNBTIngredient;

public class ModRecipeProvider
extends RecipeProvider {
    public static final Map<ResourcesSaplingBlock, Item> SAPLINGS_BY_SAPLINGS = Map.of((ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_OAK_SAPLING.get()), Items.OAK_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_SPRUCE_SAPLING.get()), Items.SPRUCE_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_BIRCH_SAPLING.get()), Items.BIRCH_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_JUNGLE_SAPLING.get()), Items.JUNGLE_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_ACACIA_SAPLING.get()), Items.ACACIA_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get()), Items.DARK_OAK_SAPLING, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_CHERRY_SAPLING.get()), Items.CHERRY_SAPLING);
    private final HolderGetter<ResourcesTypes> types;
    private final HolderLookup.Provider lookupProvider;

    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output);
        this.types = lookupProvider.join().lookupOrThrow(ModRegistries.RESOURCES_TYPES_KEY);
        this.lookupProvider = lookupProvider.join();
    }

    protected void buildRecipes(Consumer<FinishedRecipe> output) {
        this.circleShape(Items.COBBLESTONE, 12, ResourcesTypes.STONE, output);
        this.circleSurroundedShape(Items.STONE, 12, ResourcesTypes.STONE, ResourcesTypes.COAL, output);
        this.circleShape(Items.COAL, 12, ResourcesTypes.COAL, output);
        this.circleShape(Items.IRON_INGOT, 6, ResourcesTypes.IRON, output);
        this.circleShape(Items.COPPER_INGOT, 8, ResourcesTypes.COPPER, output);
        this.circleShape(Items.GOLD_INGOT, 6, ResourcesTypes.GOLD, output);
        this.circleShape(Items.LAPIS_LAZULI, 12, ResourcesTypes.LAPIS, output);
        this.cubeShape(Items.EMERALD, 4, ResourcesTypes.EMERALD, output);
        this.cubeShape(Items.DIAMOND, 4, ResourcesTypes.DIAMOND, output);
        this.circleShape(Items.OBSIDIAN, 6, ResourcesTypes.OBSIDIAN, output);
        this.lineShape(Items.AMETHYST_SHARD, 6, ResourcesTypes.AMETHYST, output);
        this.cubeShape(Items.NETHERITE_INGOT, 1, ResourcesTypes.NETHERITE, output);
        this.lineShape(Items.QUARTZ, 8, ResourcesTypes.QUARTZ, output);
        this.lineShape(Items.PRISMARINE_SHARD, 8, ResourcesTypes.PRISMARINE, output);
        this.lineShape(Items.GLOWSTONE_DUST, 8, ResourcesTypes.GLOWSTONE, output);
        this.circleShape(Items.REDSTONE, 12, ResourcesTypes.REDSTONE, output);
        this.customShape(Items.OAK_LOG, 8, ResourcesTypes.WOOD, " A ", " A ", " A ", output);
        this.lineShape(Items.BIRCH_LOG, 8, ResourcesTypes.WOOD, output);
        this.customShape(Items.JUNGLE_LOG, 8, ResourcesTypes.WOOD, "A  ", " A ", "  A", output);
        this.customShape(Items.SPRUCE_LOG, 8, ResourcesTypes.WOOD, "  A", " A ", "A  ", output);
        this.customShape(Items.ACACIA_LOG, 8, ResourcesTypes.WOOD, "  A", " A ", " A ", output);
        this.customShape(Items.DARK_OAK_LOG, 8, ResourcesTypes.WOOD, "A  ", " A ", " A ", output);
        this.customShape(Items.CHERRY_LOG, 8, ResourcesTypes.WOOD, " A ", " A ", "A  ", output);
        this.customShape(Items.BAMBOO_BLOCK, 8, ResourcesTypes.WOOD, "   ", "AA ", "  A", output);
        this.customShape(Items.CRIMSON_STEM, 8, ResourcesTypes.WOOD, "A  ", " AA", "   ", output);
        this.customShape(Items.WARPED_STEM, 8, ResourcesTypes.WOOD, "   ", " AA", "A  ", output);
        this.circleShape(Items.COBBLED_DEEPSLATE, 12, ResourcesTypes.DEEPSLATE, output);
        this.circleSurroundedShape(Items.DEEPSLATE, 12, ResourcesTypes.DEEPSLATE, ResourcesTypes.COAL, output);
        this.circleSurroundedShape(Items.TUFF, 12, ResourcesTypes.STONE, ResourcesTypes.DEEPSLATE, output);
        this.circleShape(Items.DIRT, 12, ResourcesTypes.DIRT, output);
        this.twoByTwoShape(Items.SAND, 8, ResourcesTypes.DIRT, ResourcesTypes.FIRE, output);
        this.circleSurroundedShapeWithItem(Items.RED_SAND, 8, ResourcesTypes.FIRE, Items.SAND, output);
        this.circleShape(Items.NETHERRACK, 12, ResourcesTypes.NETHER, output);
        this.circleSurroundedShape(Items.BASALT, 12, ResourcesTypes.NETHER, ResourcesTypes.STONE, output);
        this.circleSurroundedShape(Items.END_STONE, 12, ResourcesTypes.END, ResourcesTypes.STONE, output);
        this.circleSurroundedShape(Items.GRASS_BLOCK, 12, ResourcesTypes.DIRT, ResourcesTypes.NATURE, output);
        this.twoItemCustomShape(Items.PODZOL, 12, ResourcesTypes.DIRT, ResourcesTypes.WOOD, "AAA", "ABA", "AAA", output);
        this.circleSurroundedShapeWithItem(Items.MYCELIUM, 12, ResourcesTypes.DIRT, Items.BROWN_MUSHROOM_BLOCK, output);
        this.twoByTwoShape(Items.CLAY, 8, ResourcesTypes.DIRT, ResourcesTypes.WATER, output);
        this.circleSurroundedShapeWithItem(Items.MUD, 12, ResourcesTypes.WATER, Items.CLAY_BALL, output);
        this.circleSurroundedShapeWithItem(Items.GRAVEL, 12, ResourcesTypes.STONE, Items.SAND, output);
        this.circleShape(Items.ICE, 12, ResourcesTypes.ICE, output);
        this.circleSurroundedShape(Items.SNOW, 12, ResourcesTypes.ICE, ResourcesTypes.WATER, output);
        this.circleSurroundedShape(Items.MOSS_BLOCK, 12, ResourcesTypes.NATURE, ResourcesTypes.DIRT, output);
        this.circleSurroundedShape(Items.MAGMA_BLOCK, 12, ResourcesTypes.NETHER, ResourcesTypes.FIRE, output);
        this.twoItemCustomShape(Items.CRIMSON_NYLIUM, 12, ResourcesTypes.NETHER, ResourcesTypes.NATURE, "BBB", "ABA", "AAA", output);
        this.twoItemCustomShape(Items.WARPED_NYLIUM, 12, ResourcesTypes.NETHER, ResourcesTypes.NATURE, "BBB", "BAB", "AAA", output);
        this.circleSurroundedShapeWithItem(Items.SOUL_SAND, 12, ResourcesTypes.NETHER, Items.SAND, output);
        this.circleSurroundedShape(Items.SOUL_SOIL, 12, ResourcesTypes.NETHER, ResourcesTypes.DIRT, output);
        this.twoItemCustomShape(Items.OAK_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "   ", "ABA", "   ", output);
        this.twoItemCustomShape(Items.SPRUCE_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", " A ", output);
        this.twoItemCustomShape(Items.BIRCH_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "A  ", " B ", "  A", output);
        this.twoItemCustomShape(Items.JUNGLE_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "  A", " B ", "A  ", output);
        this.twoItemCustomShape(Items.ACACIA_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "  A", " B ", " A ", output);
        this.twoItemCustomShape(Items.DARK_OAK_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, "A  ", " B ", " A ", output);
        this.twoItemCustomShape(Items.MANGROVE_PROPAGULE, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", "  A", output);
        this.twoItemCustomShape(Items.CHERRY_SAPLING, 6, ResourcesTypes.WOOD, ResourcesTypes.NATURE, " A ", " B ", "A  ", output);
        this.twoItemCustomShape(Items.BROWN_MUSHROOM, 6, ResourcesTypes.NATURE, ResourcesTypes.DIRT, " A ", " B ", "A  ", output);
        this.twoItemCustomShape(Items.RED_MUSHROOM, 6, ResourcesTypes.NATURE, ResourcesTypes.DIRT, "ABA", "   ", "   ", output);
        this.twoItemCustomShape(Items.CRIMSON_FUNGUS, 6, ResourcesTypes.NATURE, ResourcesTypes.NETHER, "ABA", "   ", "   ", output);
        this.twoItemCustomShape(Items.WARPED_FUNGUS, 6, ResourcesTypes.NATURE, ResourcesTypes.NETHER, " A ", " B ", " A ", output);
        this.customShape(Items.SUGAR_CANE, 12, ResourcesTypes.NATURE, "A A", "A A", "A A", output);
        this.customShape(Items.CACTUS, 12, ResourcesTypes.NATURE, "AA ", "AA ", "   ", output);
        this.twoByTwoShape(Items.CHORUS_PLANT, 8, ResourcesTypes.END, ResourcesTypes.NATURE, output);
        this.lineShape(Items.LILY_PAD, 12, ResourcesTypes.NATURE, output);
        this.twoItemCustomShape(Items.KELP, 12, ResourcesTypes.NATURE, ResourcesTypes.WATER, "  A", " B ", "A  ", output);
        this.customShape(Items.PUMPKIN, 12, ResourcesTypes.NATURE, "AAA", "AAA", "   ", output);
        this.customShape(Items.APPLE, 12, ResourcesTypes.NATURE, "AAA", "A A", "AAA", output);
        this.customShape(Items.MELON_SLICE, 12, ResourcesTypes.NATURE, "A  ", " A ", "  A", output);
        this.customShape(Items.SWEET_BERRIES, 12, ResourcesTypes.NATURE, "  A", " A ", "A  ", output);
        this.customShape(Items.CARROT, 12, ResourcesTypes.NATURE, " A ", " A ", " A ", output);
        this.customShape(Items.POTATO, 12, ResourcesTypes.NATURE, "   ", " AA", "A  ", output);
        this.customShape(Items.BEETROOT, 12, ResourcesTypes.NATURE, "  A", " AA", "A  ", output);
        this.customShape(Items.WHEAT, 12, ResourcesTypes.NATURE, "  A", "AA ", "   ", output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.TREE_SIMULATOR.get()), (int)1).pattern("   ").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (ItemLike)Items.CYAN_TERRACOTTA).define(Character.valueOf('B'), (ItemLike)Items.GRASS_BLOCK).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.GRASS_BLOCK), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Items.GRASS_BLOCK)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Items.CYAN_TERRACOTTA), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)Items.CYAN_TERRACOTTA)).save(output);
        this.essenceItem((Item)ModItems.FIRE_ESSENCE.get(), output, Items.FIRE_CHARGE, Items.MAGMA_BLOCK, Items.LAVA_BUCKET);
        this.essenceItem((Item)ModItems.NATURE_ESSENCE.get(), output, Items.GRASS_BLOCK, Items.MOSS_BLOCK, Items.PUMPKIN, Items.MELON, Items.SUGAR_CANE, Items.CACTUS, Items.WHEAT, Items.CARROT, Items.POTATO);
        this.essenceItem((Item)ModItems.END_ESSENCE.get(), output, Items.END_STONE, Items.CHORUS_FRUIT, Items.CHORUS_PLANT, Items.PURPUR_BLOCK);
        this.essenceItem((Item)ModItems.WATER_ESSENCE.get(), output, Items.WATER_BUCKET, Items.KELP, Items.SEAGRASS, Items.CLAY_BALL);
        ResourcesTypes.getAllResourcesTypes(this.lookupProvider).forEach((key, value) -> {
            Field[] fields;
            for (Field field : fields = ModBlocks.class.getDeclaredFields()) {
                try {
                    Supplier supplier;
                    Object patt11567$temp;
                    Object obj = field.get(null);
                    if (!(obj instanceof Supplier) || !((patt11567$temp = (supplier = (Supplier)obj).get()) instanceof ResourcesSaplingBlock)) continue;
                    ResourcesSaplingBlock resourcesSaplingBlock = (ResourcesSaplingBlock)((Object)((Object)patt11567$temp));
                    ItemStack sapling = resourcesSaplingBlock.asItem().getDefaultInstance();
                    sapling.getOrCreateTag().putString("type", key.toString());
                    if (((ResourcesTypes)value.value()).material().left().isPresent()) {
                        ShapedRecipeNBTOutputBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, sapling).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)((ResourcesTypes)value.value()).material().left().get())).define(Character.valueOf('B'), (ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)((ResourcesTypes)value.value()).material().left().get()))), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)((ItemLike)BuiltInRegistries.ITEM.get((ResourceLocation)((ResourcesTypes)value.value()).material().left().get())))).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock))), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)((ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)))).save(output, key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("saplings/"));
                    } else if (((ResourcesTypes)value.value()).material().right().isPresent()) {
                        ShapedRecipeNBTOutputBuilder.shaped(RecipeCategory.BUILDING_BLOCKS, sapling).pattern(" A ").pattern("ABA").pattern(" A ").define(Character.valueOf('A'), (TagKey<Item>)((TagKey)((ResourcesTypes)value.value()).material().right().get())).define(Character.valueOf('B'), (ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)).unlockedBy("has_" + ((TagKey)((ResourcesTypes)value.value()).material().right().get()).location().getPath() + "_tags", (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)((TagKey)((ResourcesTypes)value.value()).material().right().get()))).unlockedBy(ModRecipeProvider.getHasName((ItemLike)((ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock))), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)((ItemLike)SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock)))).save(output, key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("saplings/"));
                    }
                    ItemStack leaf = ((LeafFragmentItem)((Object)((Object)ModItems.LEAF_FRAGMENT.get()))).getDefaultInstance();
                    leaf.getOrCreateTag().putString("type", key.toString());
                    TreeSimulatorRecipeBuilder.builder().setTree(sapling).addDrops(TreeSimulatorOutput.of(TreeSimulatorBlockEntity.LOG_BY_SAPLINGS.get((Object)resourcesSaplingBlock).getDefaultInstance(), 1.0f, 2, 4)).addDrops(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1)).addDrops(TreeSimulatorOutput.of(leaf, ((ResourcesTypes)value.value()).leafDropChance(), 1, 1)).addDrops(TreeSimulatorOutput.of(sapling, ((ResourcesTypes)value.value()).saplingDropChance(), 1, 1)).addDrops(TreeSimulatorOutput.of(Items.STICK.getDefaultInstance(), 0.1f, 1, 2)).addDrops(TreeSimulatorOutput.of(Items.APPLE.getDefaultInstance(), 0.05f, 1, 1)).addDrops(TreeSimulatorOutput.of(SAPLINGS_BY_SAPLINGS.get((Object)resourcesSaplingBlock).getDefaultInstance(), 0.1f, 1, 1)).setTicksToGrow(1200).save(output, key.withSuffix(BuiltInRegistries.BLOCK.getKey((Object)resourcesSaplingBlock).getPath().substring(9)).withPrefix("tree_simulator/"));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private void essenceItem(Item ouputItem, Consumer<FinishedRecipe> output, Item ... inputItems) {
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)ouputItem, (int)1);
        for (Item item : inputItems) {
            builder.requires((ItemLike)item);
            builder.unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)item));
        }
        builder.save(output);
    }

    private void circleShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("A A").pattern("AAA").define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void circleSurroundedShapeWithItem(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, Item item, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('B'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).define(Character.valueOf('A'), (ItemLike)item).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)item), (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)item)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void circleSurroundedShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> middleResourceType, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag2.putString("type", this.types.getOrThrow(middleResourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("ABA").pattern("AAA").define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).define(Character.valueOf('B'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag2, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(middleResourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag2)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void twoByTwoShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> middleResourceType, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag2.putString("type", this.types.getOrThrow(middleResourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("BA ").pattern("AB ").pattern("   ").define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).define(Character.valueOf('B'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag2, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(middleResourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag2)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void cubeShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("AAA").pattern("AAA").pattern("AAA").define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void lineShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern("   ").pattern("AAA").pattern("   ").define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void customShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, String line1, String line2, String line3, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern(line1).pattern(line2).pattern(line3).define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    private void twoItemCustomShape(Item outputItem, int count, ResourceKey<ResourcesTypes> resourceType, ResourceKey<ResourcesTypes> resourceType2, String line1, String line2, String line3, Consumer<FinishedRecipe> output) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("type", this.types.getOrThrow(resourceType).key().location().toString());
        CompoundTag compoundTag2 = new CompoundTag();
        compoundTag2.putString("type", this.types.getOrThrow(resourceType2).key().location().toString());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)outputItem, (int)count).pattern(line1).pattern(line2).pattern(line3).define(Character.valueOf('A'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).define(Character.valueOf('B'), (Ingredient)PartialNBTIngredient.of((CompoundTag)compoundTag2, (ItemLike[])new ItemLike[]{(ItemLike)ModItems.LEAF_FRAGMENT.get()})).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ModItems.LEAF_FRAGMENT.get(), this.types.getOrThrow(resourceType2).key().location()), (CriterionTriggerInstance)this.has((ItemLike)ModItems.LEAF_FRAGMENT.get(), compoundTag2)).save(output, resourceType.location().withSuffix("_fragment_to_" + ModRecipeProvider.getItemName((ItemLike)outputItem)).withPrefix("fragment_crafting/"));
    }

    protected InventoryChangeTrigger.TriggerInstance has(ItemLike itemLike, CompoundTag key) {
        return ModRecipeProvider.inventoryTrigger((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{itemLike}).hasNbt(key).build()});
    }

    protected static String getHasName(ItemLike itemLike, ResourceLocation key) {
        return "has_" + key.getPath() + "_" + ModRecipeProvider.getItemName((ItemLike)itemLike);
    }
}

