/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen.loot;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModBlockLootTables
extends BlockLootSubProvider {
    public ModBlockLootTables() {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags());
    }

    protected void generate() {
        this.dropSelf((Block)ModBlocks.RESOURCES_OAK_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_OAK_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get());
        this.dropSelf((Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get());
        this.shearOrSilkTouchOnlyDrop((Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get());
        this.dropSelf((Block)ModBlocks.TREE_SIMULATOR.get());
    }

    protected void shearOrSilkTouchOnlyDrop(Block block) {
        this.add(block, this.createShearsOrSilkTouchOnlyDrop((ItemLike)block));
    }

    protected LootTable.Builder createShearsOrSilkTouchOnlyDrop(ItemLike item) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(HAS_SHEARS_OR_SILK_TOUCH).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)item)));
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(block -> Optional.of(BuiltInRegistries.BLOCK.getKey(block)).filter(key -> key.getNamespace().equals("resourcestrees")).isPresent()).collect(Collectors.toSet());
    }
}

