/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.recipe.output;

import com.coolerpromc.resourcestrees.datagen.recipebuilder.TreeSimulatorRecipeBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;

public record TreeSimulatorOutput(ItemStack output, float chance, int minRolls, int maxRolls) {
    public static TreeSimulatorOutput of(ItemStack output, float chance, int minRolls, int maxRolls) {
        return new TreeSimulatorOutput(output, chance, minRolls, maxRolls);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("output", TreeSimulatorRecipeBuilder.itemToJson(this.output));
        jsonObject.addProperty("chance", (Number)Float.valueOf(this.chance));
        jsonObject.addProperty("minRolls", (Number)this.minRolls);
        jsonObject.addProperty("maxRolls", (Number)this.maxRolls);
        return jsonObject;
    }

    public static TreeSimulatorOutput fromJson(JsonObject jsonObject) {
        return new TreeSimulatorOutput(CraftingHelper.getItemStack((JsonObject)jsonObject.getAsJsonObject("output"), (boolean)true), GsonHelper.getAsFloat((JsonObject)jsonObject, (String)"chance"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"minRolls"), GsonHelper.getAsInt((JsonObject)jsonObject, (String)"maxRolls"));
    }

    public int getRolls(RandomSource random) {
        if (this.minRolls > this.maxRolls) {
            throw new IllegalArgumentException("minRolls cannot be greater than maxRolls");
        }
        if (this.minRolls == this.maxRolls) {
            return this.minRolls;
        }
        return random.nextInt(this.maxRolls - this.minRolls + 1) + this.minRolls;
    }

    public static void writeOutput(FriendlyByteBuf buf, TreeSimulatorOutput output) {
        buf.writeItem(output.output);
        buf.writeFloat(output.chance);
        buf.writeInt(output.minRolls);
        buf.writeInt(output.maxRolls);
    }

    public static TreeSimulatorOutput readOutput(FriendlyByteBuf buf) {
        ItemStack output = buf.readItem();
        float chance = buf.readFloat();
        int minRolls = buf.readInt();
        int maxRolls = buf.readInt();
        return new TreeSimulatorOutput(output, chance, minRolls, maxRolls);
    }
}

