/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen;

import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datagen.ModBlockTagGenerator;
import com.coolerpromc.resourcestrees.datagen.ModDatapackProvider;
import com.coolerpromc.resourcestrees.datagen.ModLootTableProvider;
import com.coolerpromc.resourcestrees.datagen.ModModelProvider;
import com.coolerpromc.resourcestrees.datagen.ModRecipeProvider;
import com.coolerpromc.resourcestrees.registry.ModRegistries;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

@EventBusSubscriber(modid="resourcestrees")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ModDatapackProvider datapackProvider = new ModDatapackProvider(packOutput, lookupProvider);
        event.addProvider((DataProvider)datapackProvider);
        event.addProvider((DataProvider)new ModModelProvider(packOutput));
        event.addProvider((DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModRecipeProvider.Runner(packOutput, datapackProvider.getRegistryProvider()));
        event.addProvider((DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
    }

    @SubscribeEvent
    public static void onDataPackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(ModRegistries.RESOURCES_TYPES_KEY, ResourcesTypes.CODEC, ResourcesTypes.CODEC, builder -> builder.maxId(500));
    }
}

