/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.worldgen.tree;

import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class ResourcesFoliagePlacer
extends FoliagePlacer {
    private final FoliagePlacer vanilla;
    private final ResourceLocation resourceType;

    public ResourcesFoliagePlacer(FoliagePlacer vanilla, ResourceLocation type) {
        super(vanilla.radius, vanilla.offset);
        this.vanilla = vanilla;
        this.resourceType = type;
    }

    public FoliagePlacerType<?> type() {
        return this.vanilla.type();
    }

    public void createFoliage(LevelSimulatedReader reader, final FoliagePlacer.FoliageSetter setter, RandomSource random, TreeConfiguration config, int trunkHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int radius, int offset) {
        final ArrayList entityBlockPositions = new ArrayList();
        this.vanilla.createFoliage(reader, new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos pos, BlockState state) {
                if (state.getBlock() instanceof EntityBlock) {
                    entityBlockPositions.add(pos.immutable());
                }
                setter.set(pos, state);
            }

            public boolean isSet(BlockPos blockPos) {
                return setter.isSet(blockPos);
            }
        }, random, config, trunkHeight, attachment, foliageHeight, radius);
        if (reader instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)reader;
            for (BlockPos pos : entityBlockPositions) {
                BlockEntity blockEntity = serverLevel.getBlockEntity(pos);
                if (!(blockEntity instanceof ResourcesTypesBlockEntity)) continue;
                ResourcesTypesBlockEntity typeBe = (ResourcesTypesBlockEntity)blockEntity;
                typeBe.setResourcesType(this.resourceType);
                typeBe.setChanged();
                serverLevel.sendBlockUpdated(pos, blockEntity.getBlockState(), blockEntity.getBlockState(), 2);
            }
        }
    }

    public int foliageHeight(RandomSource random, int trunkHeight, TreeConfiguration config) {
        return this.vanilla.foliageHeight(random, trunkHeight, config);
    }

    public boolean shouldSkipLocation(RandomSource random, int dx, int y, int dz, int radius, boolean large) {
        return this.vanilla.shouldSkipLocation(random, dx, y, dz, radius, large);
    }
}

