/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.recipe.output;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public record TreeSimulatorOutput(ItemStack output, float chance, int minRolls, int maxRolls) {
    public static final Codec<TreeSimulatorOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.CODEC.fieldOf("output").forGetter(TreeSimulatorOutput::output), (App)Codec.FLOAT.fieldOf("chance").forGetter(TreeSimulatorOutput::chance), (App)Codec.INT.fieldOf("minRolls").forGetter(TreeSimulatorOutput::minRolls), (App)Codec.INT.fieldOf("maxRolls").forGetter(TreeSimulatorOutput::maxRolls)).apply((Applicative)instance, TreeSimulatorOutput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TreeSimulatorOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, TreeSimulatorOutput::output, (StreamCodec)ByteBufCodecs.FLOAT, TreeSimulatorOutput::chance, (StreamCodec)ByteBufCodecs.INT, TreeSimulatorOutput::minRolls, (StreamCodec)ByteBufCodecs.INT, TreeSimulatorOutput::maxRolls, TreeSimulatorOutput::new);

    public static TreeSimulatorOutput of(ItemStack output, float chance, int minRolls, int maxRolls) {
        return new TreeSimulatorOutput(output, chance, minRolls, maxRolls);
    }

    public int getRolls(RandomSource random) {
        if (this.minRolls > this.maxRolls) {
            throw new IllegalArgumentException("minRolls cannot be greater than maxRolls");
        }
        if (this.minRolls == this.maxRolls) {
            return this.minRolls;
        }
        return random.nextInt(this.maxRolls - this.minRolls + 1) + this.minRolls;
    }
}

