/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModCreativeTab;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.network.packet.ResourceTypeSyncS2CPacket;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;

@Mod(value="resourcestrees")
public class ResourcesTrees {
    public static final String MODID = "resourcestrees";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ResourcesTrees(IEventBus modEventBus, ModContainer modContainer) {
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModCreativeTab.register(modEventBus);
        ModDataComponents.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onOnDatapackSync(OnDatapackSyncEvent event) {
        event.sendRecipes(new RecipeType[]{(RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get()});
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (!ModList.get().isLoaded("treeharvester")) {
            return;
        }
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        level2.getServer().schedule((Runnable)new TickTask(5, () -> {
            Block block;
            ItemStack itemStack = itemEntity.getItem();
            Item item = itemStack.getItem();
            if (!(item instanceof BlockItem) && !(item instanceof LeafFragmentItem)) {
                return;
            }
            if (item instanceof BlockItem && !((block = Block.byItem((Item)item)) instanceof ResourcesSaplingBlock)) {
                return;
            }
            if (!itemStack.has(ModDataComponents.TYPE)) {
                return;
            }
            Holder type = (Holder)itemStack.get(ModDataComponents.TYPE);
            if (type != null) {
                if (itemEntity.isRemoved()) {
                    return;
                }
                BlockPos pos = ResourcesTrees.findNearbyBlock((Level)level2, itemEntity.getOnPos(), 5, 50);
                if (pos.equals((Object)BlockPos.ZERO)) {
                    return;
                }
                if (!(level2.getBlockState(pos).getBlock() instanceof ResourcesSaplingBlock)) {
                    return;
                }
                if (!level2.isLoaded(pos)) {
                    return;
                }
                BlockEntity blockEntity = level2.getBlockEntity(pos);
                if (!(blockEntity instanceof ResourcesTypesBlockEntity)) {
                    return;
                }
                ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
                be.setResourcesType((Holder<ResourcesTypes>)type);
                be.setChanged();
                level2.sendBlockUpdated(pos, level2.getBlockState(pos), level2.getBlockState(pos), 3);
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ResourceTypeSyncS2CPacket(be.getBlockPos(), (Holder<ResourcesTypes>)type), (CustomPacketPayload[])new CustomPacketPayload[0]);
                List<BlockPos> nearbyPos = ResourcesTrees.findAllNearbyBlock((Level)level2, pos, 1);
                for (BlockPos blockPos : nearbyPos) {
                    BlockEntity neighbourBe;
                    if (blockPos.equals((Object)pos) || !((neighbourBe = level2.getBlockEntity(blockPos)) instanceof ResourcesTypesBlockEntity)) continue;
                    ResourcesTypesBlockEntity be2 = (ResourcesTypesBlockEntity)neighbourBe;
                    be2.setResourcesType((Holder<ResourcesTypes>)type);
                    be2.setChanged();
                    PacketDistributor.sendToAllPlayers((CustomPacketPayload)new ResourceTypeSyncS2CPacket(be2.getBlockPos(), (Holder<ResourcesTypes>)type), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }));
    }

    public static BlockPos findNearbyBlock(Level level, BlockPos center, int radiusXZ, int radiusY) {
        for (int x = -radiusXZ; x <= radiusXZ; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusXZ; z <= radiusXZ; ++z) {
                    ResourcesTypesBlockEntity be;
                    BlockEntity entity;
                    BlockPos checkPos = center.offset(x, y, z);
                    if (!(level.getBlockState(checkPos).getBlock() instanceof ResourcesSaplingBlock) || !((entity = level.getBlockEntity(checkPos)) instanceof ResourcesTypesBlockEntity) || (be = (ResourcesTypesBlockEntity)entity).getResourcesType() != null) continue;
                    return checkPos;
                }
            }
        }
        return BlockPos.ZERO;
    }

    public static List<BlockPos> findAllNearbyBlock(Level level, BlockPos center, int radius) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = center.offset(x, y, z);
                    if (!(level.getBlockState(checkPos).getBlock() instanceof ResourcesSaplingBlock)) continue;
                    pos.add(checkPos);
                }
            }
        }
        return pos;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }
}

