/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.recipe.custom;

import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record TreeSimulatorRecipe(ItemStack tree, List<TreeSimulatorOutput> drops, int ticksToGrow) implements Recipe<TreeSimulatorRecipeInput>
{
    public boolean matches(TreeSimulatorRecipeInput treeSimulatorRecipeInput, Level level) {
        return ResourcesTypes.isSameItemSameType(this.tree, treeSimulatorRecipeInput.tree());
    }

    public ItemStack assemble(TreeSimulatorRecipeInput treeSimulatorRecipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<? extends Recipe<TreeSimulatorRecipeInput>> getSerializer() {
        return (RecipeSerializer)ModRecipes.TREE_SIMULATOR_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<TreeSimulatorRecipeInput>> getType() {
        return (RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get();
    }

    public PlacementInfo placementInfo() {
        return PlacementInfo.NOT_PLACEABLE;
    }

    public RecipeBookCategory recipeBookCategory() {
        return null;
    }

    public static class Serializer
    implements RecipeSerializer<TreeSimulatorRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<TreeSimulatorRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.CODEC.fieldOf("tree").forGetter(TreeSimulatorRecipe::tree), (App)Codec.list(TreeSimulatorOutput.CODEC).fieldOf("drops").forGetter(TreeSimulatorRecipe::drops), (App)Codec.INT.fieldOf("ticksToGrow").forGetter(TreeSimulatorRecipe::ticksToGrow)).apply((Applicative)instance, TreeSimulatorRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, TreeSimulatorRecipe> streamCodec() {
            return StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, TreeSimulatorRecipe::tree, (StreamCodec)TreeSimulatorOutput.STREAM_CODEC.apply(ByteBufCodecs.list()), TreeSimulatorRecipe::drops, (StreamCodec)ByteBufCodecs.INT, TreeSimulatorRecipe::ticksToGrow, TreeSimulatorRecipe::new);
        }
    }
}

