/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.screen.custom;

import com.coolerpromc.resourcestrees.block.entity.custom.TreeSimulatorBlockEntity;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.coolerpromc.resourcestrees.screen.container.OutputSlot;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import org.jetbrains.annotations.NotNull;

public class TreeSimulatorMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 11;
    protected final ContainerData data;

    public TreeSimulatorMenu(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf byteBuf) {
        this(containerId, playerInventory, (TreeSimulatorBlockEntity)playerInventory.player.level().getBlockEntity(byteBuf.readBlockPos()), (ContainerData)new SimpleContainerData(2));
    }

    public TreeSimulatorMenu(int containerId, Inventory playerInventory, TreeSimulatorBlockEntity blockEntity, ContainerData data) {
        super(ModMenuTypes.TREE_SIMULATOR.get(), containerId);
        this.data = data;
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.addDataSlots(this.data);
        ItemStacksResourceHandler inputHandler = blockEntity.getInputHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)inputHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)inputHandler).set(arg_0, arg_1, arg_2), 0, 26, 35));
        ItemStacksResourceHandler outputHandler = blockEntity.getOutputHandler();
        for (int i = 0; i < blockEntity.getOutputHandler().size(); ++i) {
            this.addSlot((Slot)new OutputSlot(outputHandler, i, 98 + 18 * (i % 3), 17 + i / 3 * 18, itemStack -> false));
        }
        ItemStacksResourceHandler axeHandler = blockEntity.getAxeHandler();
        this.addSlot((Slot)new ResourceHandlerSlot((ResourceHandler)axeHandler, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)axeHandler).set(arg_0, arg_1, arg_2), 0, 62, 59));
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 47, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 47) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(pPlayer, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 102 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 160));
        }
    }

    public int getCurrentProgress() {
        return this.data.get(0);
    }

    public int getMaxProgress() {
        return this.data.get(1);
    }

    public int getProgress() {
        return Math.round((float)this.getCurrentProgress() / (float)this.getMaxProgress() * 22.0f);
    }
}

