/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.custom;

import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ResourcesLeavesBlock
extends LeavesBlock
implements EntityBlock {
    private final Supplier<ResourcesSaplingBlock> sapling;

    public ResourcesLeavesBlock(BlockBehaviour.Properties properties, Supplier<ResourcesSaplingBlock> sapling) {
        super(properties);
        this.sapling = sapling;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            ResourceLocation type = be.getResourcesType();
            ResourcesTypes resourcesTypes = ResourcesTypes.byId(type, (Level)builder.m_287258_());
            if (drops.isEmpty()) {
                CompoundTag tag;
                if (builder.m_287258_().m_213780_().m_188501_() < resourcesTypes.saplingChance()) {
                    ItemStack saplingDrop = this.sapling.get().m_5456_().m_7968_();
                    tag = saplingDrop.m_41784_();
                    tag.m_128359_("type", type.toString());
                    drops.add(saplingDrop);
                }
                ItemStack fragment = ((LeafFragmentItem)((Object)ModItems.LEAF_FRAGMENT.get())).m_7968_();
                tag = fragment.m_41784_();
                tag.m_128359_("type", type.toString());
                drops.add(fragment.m_41777_());
                if (builder.m_287258_().m_213780_().m_188501_() < resourcesTypes.secondaryDropChance()) {
                    drops.add(fragment.m_41777_());
                }
            } else if (Block.m_49814_((Item)((ItemStack)drops.get(0)).m_41720_()) instanceof ResourcesLeavesBlock) {
                ((ItemStack)drops.get(0)).m_41784_().m_128359_("type", type.toString());
            }
        }
        return drops;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("type")) {
                be.setResourcesType(new ResourceLocation(stack.m_41783_().m_128461_("type")));
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
            stack.m_41784_().m_128359_("type", be.getResourcesType().toString());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ResourcesTypesBlockEntity(blockPos, blockState);
    }
}

