/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.custom;

import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.worldgen.tree.ResourcesFoliagePlacer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.AbstractMegaTreeGrower;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ResourcesSaplingBlock
extends SaplingBlock
implements EntityBlock {
    private final ResourceLocation leaves;

    public ResourcesSaplingBlock(AbstractTreeGrower treeGrower, BlockBehaviour.Properties properties, ResourceLocation leaves) {
        super(treeGrower, properties);
        this.leaves = leaves;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        List drops = super.m_49635_(state, params);
        BlockEntity blockEntity = (BlockEntity)params.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (!drops.isEmpty() && be.getResourcesType() != null) {
                ((ItemStack)drops.get(0)).m_41784_().m_128359_("type", be.getResourcesType().toString());
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
            stack.m_41784_().m_128359_("type", be.getResourcesType().toString());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (stack.m_41782_() && stack.m_41783_().m_128441_("type")) {
                be.setResourcesType(new ResourceLocation(stack.m_41783_().m_128461_("type")));
            }
        }
    }

    public void m_222000_(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (state.m_60734_() instanceof ResourcesSaplingBlock && blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ResourceKey resourcekey1;
            Holder holder;
            ResourceLocation type = be.getResourcesType();
            ResourcesTypes resourcesTypes = ResourcesTypes.byId(type, (Level)level);
            ResourceKey resourcekey = null;
            AbstractTreeGrower abstractTreeGrower = this.f_55975_;
            if (abstractTreeGrower instanceof AbstractMegaTreeGrower) {
                AbstractMegaTreeGrower megaTreeGrower = (AbstractMegaTreeGrower)abstractTreeGrower;
                resourcekey = megaTreeGrower.m_213566_(random);
            }
            if (resourcekey != null && (holder = (Holder)level.m_9598_().m_255025_(Registries.f_256911_).m_254902_(resourcekey).orElse(null)) != null) {
                ConfiguredFeature feature = (ConfiguredFeature)holder.m_203334_();
                for (int i = 0; i >= -1; --i) {
                    for (int j = 0; j >= -1; --j) {
                        TreeConfiguration oldConfig;
                        TreeConfiguration config;
                        if (!ResourcesSaplingBlock.isTwoByTwoSapling(state, (BlockGetter)level, pos, i, j)) continue;
                        BlockState blockstate = Blocks.f_50016_.m_49966_();
                        level.m_7731_(pos.m_7918_(i, 0, j), blockstate, 260);
                        level.m_7731_(pos.m_7918_(i + 1, 0, j), blockstate, 260);
                        level.m_7731_(pos.m_7918_(i, 0, j + 1), blockstate, 260);
                        level.m_7731_(pos.m_7918_(i + 1, 0, j + 1), blockstate, 260);
                        FeatureConfiguration featureConfiguration = feature.f_65378_();
                        if (featureConfiguration instanceof TreeConfiguration && Feature.f_65760_.m_225028_((FeatureConfiguration)(config = ResourcesSaplingBlock.createNewTree(type, oldConfig = (TreeConfiguration)featureConfiguration, random, pos, resourcesTypes.weight(), this.leaves)), (WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos.m_7918_(i, 0, j))) {
                            return;
                        }
                        level.m_7731_(pos.m_7918_(i, 0, j), state, 260);
                        level.m_7731_(pos.m_7918_(i + 1, 0, j), state, 260);
                        level.m_7731_(pos.m_7918_(i, 0, j + 1), state, 260);
                        level.m_7731_(pos.m_7918_(i + 1, 0, j + 1), state, 260);
                        return;
                    }
                }
            }
            if ((resourcekey1 = this.f_55975_.m_213888_(random, this.f_55975_.m_60011_((LevelAccessor)level, pos))) != null) {
                Holder holder2 = level.m_9598_().m_255025_(Registries.f_256911_).m_254902_(resourcekey1).orElse(null);
                if (holder2 != null) {
                    TreeConfiguration oldConfig;
                    TreeConfiguration config;
                    boolean success;
                    ConfiguredFeature feature = (ConfiguredFeature)holder2.m_203334_();
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 4);
                    FeatureConfiguration blockstate = feature.f_65378_();
                    if (blockstate instanceof TreeConfiguration && !(success = Feature.f_65760_.m_225028_((FeatureConfiguration)(config = ResourcesSaplingBlock.createNewTree(type, oldConfig = (TreeConfiguration)blockstate, random, pos, resourcesTypes.weight(), this.leaves)), (WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos))) {
                        level.m_7731_(pos, state, 3);
                    }
                }
                return;
            }
        }
        super.m_222000_(level, pos, state, random);
    }

    public static TreeConfiguration createNewTree(ResourceLocation type, TreeConfiguration oldConfig, RandomSource randomSource, BlockPos pos, int weight, ResourceLocation leaves) {
        Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(leaves);
        return new TreeConfiguration.TreeConfigurationBuilder(oldConfig.f_68185_, oldConfig.f_68190_, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)oldConfig.f_161213_.m_213972_(randomSource, pos), 10).m_146271_((Object)block.m_49966_(), weight).m_146270_()), (FoliagePlacer)new ResourcesFoliagePlacer(oldConfig.f_68189_, type), oldConfig.f_68191_).m_68251_();
    }

    public static boolean isTwoByTwoSapling(BlockState state, BlockGetter level, BlockPos pos, int xOffset, int yOffset) {
        Block block = state.m_60734_();
        BlockEntity blockEntity = level.m_7702_(pos);
        BlockEntity blockEntity1 = level.m_7702_(pos.m_7918_(xOffset, 0, yOffset));
        BlockEntity blockEntity2 = level.m_7702_(pos.m_7918_(xOffset + 1, 0, yOffset));
        BlockEntity blockEntity3 = level.m_7702_(pos.m_7918_(xOffset, 0, yOffset + 1));
        BlockEntity blockEntity4 = level.m_7702_(pos.m_7918_(xOffset + 1, 0, yOffset + 1));
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (blockEntity1 instanceof ResourcesTypesBlockEntity) {
                ResourcesTypesBlockEntity be1 = (ResourcesTypesBlockEntity)blockEntity1;
                if (blockEntity2 instanceof ResourcesTypesBlockEntity) {
                    ResourcesTypesBlockEntity be2 = (ResourcesTypesBlockEntity)blockEntity2;
                    if (blockEntity3 instanceof ResourcesTypesBlockEntity) {
                        ResourcesTypesBlockEntity be3 = (ResourcesTypesBlockEntity)blockEntity3;
                        if (blockEntity4 instanceof ResourcesTypesBlockEntity) {
                            ResourcesTypesBlockEntity be4 = (ResourcesTypesBlockEntity)blockEntity4;
                            ResourceLocation type = be.getResourcesType();
                            ResourceLocation type1 = be1.getResourcesType();
                            ResourceLocation type2 = be2.getResourcesType();
                            ResourceLocation type3 = be3.getResourcesType();
                            ResourceLocation type4 = be4.getResourcesType();
                            BlockState state1 = level.m_8055_(pos.m_7918_(xOffset, 0, yOffset));
                            boolean cond1 = state1.m_60713_(block) && type1.equals((Object)type);
                            BlockState state2 = level.m_8055_(pos.m_7918_(xOffset + 1, 0, yOffset));
                            boolean cond2 = state2.m_60713_(block) && type2.equals((Object)type);
                            BlockState state3 = level.m_8055_(pos.m_7918_(xOffset, 0, yOffset + 1));
                            boolean cond3 = state3.m_60713_(block) && type3.equals((Object)type);
                            BlockState state4 = level.m_8055_(pos.m_7918_(xOffset + 1, 0, yOffset + 1));
                            boolean cond4 = state4.m_60713_(block) && type4.equals((Object)type);
                            return cond1 && cond2 && cond3 && cond4;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ResourcesTypesBlockEntity(blockPos, blockState);
    }

    public ItemStack getLeaves(ResourceLocation type) {
        ItemStack stack = ((Item)BuiltInRegistries.f_257033_.m_7745_(this.leaves)).m_7968_();
        stack.m_41784_().m_128359_("type", type.toString());
        return stack;
    }

    public ResourceLocation getLeaves() {
        return this.leaves;
    }

    public AbstractTreeGrower getTreeGrower() {
        return this.f_55975_;
    }
}

