/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.screen.custom;

import com.coolerpromc.resourcestrees.block.entity.custom.TreeSimulatorBlockEntity;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.coolerpromc.resourcestrees.screen.container.OutputSlot;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class TreeSimulatorMenu
extends AbstractContainerMenu {
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 11;
    protected final ContainerData data;

    public TreeSimulatorMenu(int containerId, Inventory playerInventory, FriendlyByteBuf byteBuf) {
        this(containerId, playerInventory, (TreeSimulatorBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(byteBuf.m_130135_()), (ContainerData)new SimpleContainerData(2));
    }

    public TreeSimulatorMenu(int containerId, Inventory playerInventory, TreeSimulatorBlockEntity blockEntity, ContainerData data) {
        super(ModMenuTypes.TREE_SIMULATOR.get(), containerId);
        this.data = data;
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.m_38884_(this.data);
        ItemStackHandler inputHandler = blockEntity.getInputHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inputHandler, 0, 26, 35));
        ItemStackHandler outputHandler = blockEntity.getOutputHandler();
        for (int i = 0; i < blockEntity.getOutputHandler().getSlots(); ++i) {
            this.m_38897_((Slot)new OutputSlot((IItemHandler)outputHandler, i, 98 + 18 * (i % 3), 17 + i / 3 * 18, itemStack -> false));
        }
        ItemStackHandler axeHandler = blockEntity.getAxeHandler();
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)axeHandler, 0, 62, 59));
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (!sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(sourceStack, 36, 47, false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < 47) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(pPlayer, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 102 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 160));
        }
    }

    public int getCurrentProgress() {
        return this.data.m_6413_(0);
    }

    public int getMaxProgress() {
        return this.data.m_6413_(1);
    }

    public int getProgress() {
        return Math.round((float)this.getCurrentProgress() / (float)this.getMaxProgress() * 22.0f);
    }
}

