/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.custom;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datagen.ModRecipeProvider;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeSimulatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final Map<ResourcesSaplingBlock, Item> LOG_BY_SAPLINGS = Map.of((ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_OAK_SAPLING.get()), Items.f_41837_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_SPRUCE_SAPLING.get()), Items.f_41838_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_BIRCH_SAPLING.get()), Items.f_41839_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_JUNGLE_SAPLING.get()), Items.f_41840_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_ACACIA_SAPLING.get()), Items.f_41841_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get()), Items.f_41842_, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_CHERRY_SAPLING.get()), Items.f_271090_);
    public int growTicks = 0;
    public int maxGrowTicks = 0;
    private final ItemStackHandler inputHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            Optional<TreeSimulatorRecipe> recipeHolder = TreeSimulatorBlockEntity.this.getCurrentRecipe();
            if (recipeHolder.isPresent()) {
                TreeSimulatorRecipe recipe = recipeHolder.get();
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(recipe.ticksToGrow());
            } else {
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(0);
            }
        }
    };
    private final ItemStackHandler outputHandler = new ItemStackHandler(9);
    private final ItemStackHandler axeHandler = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof AxeItem;
        }
    };
    private final ContainerData data = new ContainerData(){

        public int m_6413_(int i) {
            return switch (i) {
                case 0 -> TreeSimulatorBlockEntity.this.growTicks;
                case 1 -> TreeSimulatorBlockEntity.this.maxGrowTicks;
                default -> 0;
            };
        }

        public void m_8050_(int i, int value) {
            switch (i) {
                case 0: {
                    TreeSimulatorBlockEntity.this.growTicks = value;
                    break;
                }
                case 1: {
                    TreeSimulatorBlockEntity.this.maxGrowTicks = value;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };

    public TreeSimulatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.TREE_SIMULATOR_BE.get(), pos, blockState);
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"Tree Simulator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new TreeSimulatorMenu(i, inventory, this, this.data);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("input", (Tag)this.inputHandler.serializeNBT());
        tag.m_128365_("output", (Tag)this.outputHandler.serializeNBT());
        tag.m_128365_("axe", (Tag)this.axeHandler.serializeNBT());
        tag.m_128405_("growTicks", this.growTicks);
        tag.m_128405_("maxGrowTicks", this.maxGrowTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.inputHandler.deserializeNBT(tag.m_128469_("input"));
        this.outputHandler.deserializeNBT(tag.m_128469_("output"));
        this.axeHandler.deserializeNBT(tag.m_128469_("axe"));
        this.data.m_8050_(0, tag.m_128451_("growTicks"));
        this.data.m_8050_(1, tag.m_128451_("maxGrowTicks"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128405_("growTicks", this.growTicks);
        tag.m_128405_("maxGrowTicks", this.maxGrowTicks);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.m_142466_(pkt.m_131708_());
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.m_5776_()) {
            return;
        }
        if (this.hasRecipe() && this.isAxeValid()) {
            this.increaseGrowTicks();
            TreeSimulatorBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.treeGrown()) {
                this.harvest(level);
                this.resetGrowTicks();
            }
        } else {
            this.resetGrowTicks();
        }
        this.m_6596_();
        level.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
    }

    private void harvest(Level level) {
        Optional<TreeSimulatorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ArrayList results = new ArrayList();
            recipe.get().drops().forEach(output -> {
                int rolls = output.getRolls(level.f_46441_);
                for (int i = 0; i < rolls; ++i) {
                    if (!(level.f_46441_.m_188501_() < output.chance())) continue;
                    results.add(output.output().m_41777_());
                }
            });
            if (!this.isAxeUnbreakable()) {
                ItemStack axe = this.getAxe();
                int damage = axe.m_41773_();
                axe.m_41721_(damage + 1);
            }
            for (ItemStack result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.insertItem(outputSlot, result, false);
                    continue;
                }
                ResourcesTrees.LOGGER.warn("No suitable output slot found for item: {} at {}", (Object)result, (Object)this.m_58899_());
            }
        }
    }

    private boolean treeGrown() {
        return this.growTicks >= this.maxGrowTicks;
    }

    private void increaseGrowTicks() {
        ++this.growTicks;
    }

    private void resetGrowTicks() {
        this.growTicks = 0;
    }

    private void setMaxGrowTicks(int tick) {
        this.data.m_8050_(1, tick);
    }

    private int findSuitableOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.m_41613_() + result.m_41613_() > stackInSlot.m_41741_())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<TreeSimulatorRecipe> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        List<ItemStack> results = recipe.get().drops().stream().map(TreeSimulatorOutput::output).toList();
        for (ItemStack result : results) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result)) continue;
            return false;
        }
        return this.checkSlot(results);
    }

    private boolean checkSlot(List<ItemStack> results) {
        int count = results.size();
        int emptyCount = 0;
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) {
                for (ItemStack result : results) {
                    if (stackInSlot.m_41720_() != result.m_41720_() || stackInSlot.m_41613_() + result.m_41613_() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.m_41613_() + result.m_41613_() > stackInSlot.m_41741_())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack item) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_() && !ResourcesTypes.isSameItemSameType(stackInSlot, item)) continue;
            return true;
        }
        return false;
    }

    private Optional<TreeSimulatorRecipe> getCurrentRecipe() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional recipe = serverLevel.m_7465_().m_44015_((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get(), (Container)new TreeSimulatorRecipeInput(this.getSapling()), (Level)serverLevel);
            if (recipe.isPresent()) {
                return recipe;
            }
            Block block = Block.m_49814_((Item)this.getSapling().m_41720_());
            if (block instanceof ResourcesSaplingBlock) {
                ResourcesSaplingBlock block2 = (ResourcesSaplingBlock)block;
                if (this.getSapling().m_41782_() && this.getSapling().m_41783_().m_128441_("type")) {
                    ResourceLocation type = new ResourceLocation(this.getSapling().m_41783_().m_128461_("type"));
                    ResourcesTypes value = ResourcesTypes.byId(type, (Level)serverLevel);
                    ItemStack leaf = ((LeafFragmentItem)((Object)ModItems.LEAF_FRAGMENT.get())).m_7968_();
                    leaf.m_41784_().m_128359_("type", type.toString());
                    if (value != ResourcesTypes.EMPTY) {
                        ArrayList<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
                        drops.add(TreeSimulatorOutput.of(LOG_BY_SAPLINGS.get((Object)block2).m_7968_(), 1.0f, 2, 4));
                        drops.add(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1));
                        drops.add(TreeSimulatorOutput.of(leaf, value.secondaryDropChance(), 1, 1));
                        drops.add(TreeSimulatorOutput.of(this.getSapling(), value.saplingChance(), 1, 1));
                        drops.add(TreeSimulatorOutput.of(Items.f_42398_.m_7968_(), 0.1f, 1, 2));
                        drops.add(TreeSimulatorOutput.of(Items.f_42410_.m_7968_(), 0.05f, 1, 1));
                        drops.add(TreeSimulatorOutput.of(ModRecipeProvider.SAPLINGS_BY_SAPLINGS.get((Object)block2).m_7968_(), 0.1f, 1, 1));
                        TreeSimulatorRecipe newRecipe = new TreeSimulatorRecipe(this.getSapling(), drops, 1200, type.m_266382_(BuiltInRegistries.f_256975_.m_7981_((Object)block2).m_135815_().substring(9)).m_246208_("tree_simulator/"));
                        return Optional.of(newRecipe);
                    }
                }
            }
        }
        return Optional.empty();
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ItemStack getSapling() {
        return this.inputHandler.getStackInSlot(0);
    }

    public ContainerData getData() {
        return this.data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (side == Direction.DOWN && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.outputHandler).cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getAxeHandler() {
        return this.axeHandler;
    }

    public ItemStack getAxe() {
        return this.axeHandler.getStackInSlot(0);
    }

    public boolean isAxeUnbreakable() {
        return this.getAxe().m_41782_() && this.getAxe().m_41783_().m_128441_("Unbreakable") || this.getAxe().m_41776_() == 0 && this.getAxe() != ItemStack.f_41583_;
    }

    public boolean isAxeValid() {
        int maxDamage;
        ItemStack axe = this.getAxe();
        int damage = axe.m_41773_();
        if (damage >= (maxDamage = axe.m_41776_()) && axe != ItemStack.f_41583_) {
            this.axeHandler.extractItem(0, 1, false);
        }
        return damage < maxDamage || this.isAxeUnbreakable();
    }
}

