/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.compat.jei.category;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.compat.jei.ModJEIPlugin;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record TreeSimulatorCategory(IGuiHelper guiHelper) implements IRecipeCategory<TreeSimulatorRecipe>
{
    public static final ResourceLocation TEXTURE = ResourcesTrees.id("textures/gui/tree_simulator.png");
    private static int tickCount = 0;

    public void draw(TreeSimulatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280218_(TEXTURE, 0, 0, 20, 15, 137, 65);
        int arrowWidth = ++tickCount % 600 * 23 / 600;
        ResourceLocation texture = ResourcesTrees.id("textures/gui/progress.png");
        guiGraphics.m_280163_(texture, 39, 20, 0.0f, 0.0f, arrowWidth, 16, 22, 16);
        guiGraphics.m_280509_(41, 43, 60, 62, -3750202);
        MutableComponent text = Component.m_237110_((String)"tooltip.resourcestrees.tickToGrow", (Object[])new Object[]{recipe.ticksToGrow()});
        guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)text, 0, 58, -10066330, false);
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, TreeSimulatorRecipe recipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 6, 20).addItemStack(recipe.tree());
        List<TreeSimulatorOutput> drops = recipe.drops();
        for (int i = 0; i < drops.size(); ++i) {
            int finalI = i;
            ((IRecipeSlotBuilder)iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 78 + 18 * (i % 3), 2 + i / 3 * 18).addItemStack(drops.get(i).output())).addRichTooltipCallback((r, t) -> this.tooltipCallback(r, t, (TreeSimulatorOutput)drops.get(finalI)));
        }
    }

    private void tooltipCallback(IRecipeSlotView ignored, ITooltipBuilder tooltipBuilder, TreeSimulatorOutput output) {
        int chance = (int)(output.chance() * 100.0f);
        String chanceStr = String.format("Output Chance: %s", chance);
        tooltipBuilder.add((FormattedText)Component.m_237113_((String)chanceStr).m_130946_("%").m_130940_(ChatFormatting.GRAY));
    }

    public RecipeType<TreeSimulatorRecipe> getRecipeType() {
        return ModJEIPlugin.TREE_SIMULATOR_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"block.resourcestrees.tree_simulator");
    }

    public int getWidth() {
        return 137;
    }

    public int getHeight() {
        return 65;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.TREE_SIMULATOR.get()));
    }
}

