/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen.recipebuilder;

import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TreeSimulatorRecipeBuilder
implements RecipeBuilder {
    private ItemStack tree;
    private final List<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
    private int ticksToGrow;
    private final Map<String, CriterionTriggerInstance> criteria = new LinkedHashMap<String, CriterionTriggerInstance>();
    @Nullable
    private String group;

    public static TreeSimulatorRecipeBuilder builder() {
        return new TreeSimulatorRecipeBuilder();
    }

    private TreeSimulatorRecipeBuilder() {
    }

    public TreeSimulatorRecipeBuilder setTree(ItemStack itemStack) {
        this.tree = itemStack;
        return this;
    }

    public TreeSimulatorRecipeBuilder addDrops(TreeSimulatorOutput drop) {
        this.drops.add(drop);
        return this;
    }

    public TreeSimulatorRecipeBuilder setTicksToGrow(int ticksToGrow) {
        this.ticksToGrow = ticksToGrow;
        return this;
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public TreeSimulatorRecipeBuilder group(@Nullable String s) {
        this.group = s;
        return this;
    }

    public Item m_142372_() {
        return Items.f_41852_;
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation resourceLocation) {
        consumer.accept(new Result(this.tree, this.drops, this.ticksToGrow, resourceLocation));
    }

    public static JsonElement itemToJson(ItemStack stack) {
        JsonObject json = new JsonObject();
        json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (stack.m_41782_()) {
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    public record Result(ItemStack tree, List<TreeSimulatorOutput> drops, int ticksToGrow, ResourceLocation id) implements FinishedRecipe
    {
        public void m_7917_(JsonObject jsonObject) {
            jsonObject.addProperty("type", "resourcestrees:tree_simulator");
            jsonObject.add("tree", TreeSimulatorRecipeBuilder.itemToJson(this.tree));
            JsonArray drops = new JsonArray();
            for (TreeSimulatorOutput output : this.drops) {
                drops.add(output.toJson());
            }
            jsonObject.add("drops", (JsonElement)drops);
            jsonObject.addProperty("ticksToGrow", (Number)this.ticksToGrow);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ModRecipes.TREE_SIMULATOR_SERIALIZER.get();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

