/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.recipe.custom;

import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public record TreeSimulatorRecipe(ItemStack tree, List<TreeSimulatorOutput> drops, int ticksToGrow, ResourceLocation id) implements Recipe<TreeSimulatorRecipeInput>
{
    public boolean matches(TreeSimulatorRecipeInput treeSimulatorRecipeInput, Level level) {
        return ResourcesTypes.isSameItemSameType(this.tree, treeSimulatorRecipeInput.tree());
    }

    public ItemStack assemble(TreeSimulatorRecipeInput treeSimulatorRecipeInput, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<? extends Recipe<TreeSimulatorRecipeInput>> m_7707_() {
        return (RecipeSerializer)ModRecipes.TREE_SIMULATOR_SERIALIZER.get();
    }

    public RecipeType<? extends Recipe<TreeSimulatorRecipeInput>> m_6671_() {
        return (RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<TreeSimulatorRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public TreeSimulatorRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            ItemStack tree = ShapedRecipe.m_151274_((JsonObject)jsonObject.getAsJsonObject("tree"));
            JsonArray dropsJson = jsonObject.getAsJsonArray("drops");
            ArrayList<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
            for (JsonElement dropJson : dropsJson) {
                drops.add(TreeSimulatorOutput.fromJson(dropJson.getAsJsonObject()));
            }
            int ticksToGrow = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"ticksToGrow");
            return new TreeSimulatorRecipe(tree, drops, ticksToGrow, resourceLocation);
        }

        @Nullable
        public TreeSimulatorRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf buf) {
            ItemStack tree = buf.m_130267_();
            List drops = buf.m_236845_(TreeSimulatorOutput::readOutput);
            int ticksToGrow = buf.readInt();
            ResourceLocation id = buf.m_130281_();
            return new TreeSimulatorRecipe(tree, drops, ticksToGrow, id);
        }

        public void toNetwork(FriendlyByteBuf buf, TreeSimulatorRecipe recipe) {
            buf.m_130055_(recipe.tree);
            buf.m_236828_(recipe.drops, TreeSimulatorOutput::writeOutput);
            buf.writeInt(recipe.ticksToGrow);
            buf.m_130085_(recipe.id);
        }
    }
}

