/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.custom;

import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jetbrains.annotations.Nullable;

public class ResourcesTypesBlockEntity
extends BlockEntity {
    private ResourceLocation resourcesType = null;

    public ResourcesTypesBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.RESOURCES_TYPE_BE.get(), pos, blockState);
    }

    public void setResourcesType(ResourceLocation resourcesType) {
        this.resourcesType = resourcesType;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public ResourceLocation getResourcesType() {
        return this.resourcesType;
    }

    public int getColor() {
        return ResourcesTypes.byId(this.getResourcesType(), this.level).color();
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (this.resourcesType != null) {
            output.putString("type", this.resourcesType.toString());
        }
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.getString("type").ifPresent(s -> this.setResourcesType(ResourceLocation.parse((String)s)));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(ValueInput tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
        this.loadAdditional(tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        if (this.resourcesType != null) {
            tag.putString("type", this.resourcesType.toString());
        }
        return tag;
    }

    public void onDataPacket(Connection connection, ValueInput data, HolderLookup.Provider lookup) {
        this.handleUpdateTag(data, lookup);
        if (this.level != null && this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

