/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.datagen.model.ResourcesTypeTintSource;
import com.coolerpromc.resourcestrees.item.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModModelProvider
extends ModelProvider {
    public static final TextureSlot CROSS_TINTED_SLOT = TextureSlot.create((String)"cross_tinted");
    public static final ModelTemplate CROSS_TINTED = new ModelTemplate(Optional.of(ResourcesTrees.id("block/cross_tinted")), Optional.empty(), new TextureSlot[]{TextureSlot.CROSS, CROSS_TINTED_SLOT});

    public ModModelProvider(PackOutput output) {
        super(output);
    }

    protected BlockModelGenerators getBlockModelGenerators(ModelProvider.BlockStateGeneratorCollector blocks, ModelProvider.ItemInfoCollector items, ModelProvider.SimpleModelCollector models) {
        return new BlockModelGenerators((Consumer)blocks, (ItemModelOutput)items, (BiConsumer)models){

            public void run() {
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_OAK_LEAVES.get(), -12012264);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_OAK_SAPLING.get(), -12012264);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), -10380959);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), -10380959);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), -8345771);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), -8345771);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), -12012264);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), -12012264);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), -12012264);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), -12012264);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), -12012264);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), -12012264);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get(), -209945);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), -209945);
                this.generateResourcesLeaves((Block)ModBlocks.RESOURCES_PALE_OAK_LEAVES.get(), -8157056);
                this.generateResourcesSapling((Block)ModBlocks.RESOURCES_PALE_OAK_SAPLING.get(), -8157056);
                this.blockWithExistingModel((Block)ModBlocks.TREE_SIMULATOR.get());
            }

            private void generateResourcesLeaves(Block block, int defaultColor) {
                ResourceLocation blockModel = TexturedModel.LEAVES.create(block, this.modelOutput);
                this.blockStateOutput.accept(1.createSimpleBlock((Block)block, (MultiVariant)1.plainVariant((ResourceLocation)blockModel)));
                this.itemModelOutput.accept(block.asItem(), ItemModelUtils.tintedModel((ResourceLocation)blockModel, (ItemTintSource[])new ItemTintSource[]{new ResourcesTypeTintSource(defaultColor)}));
            }

            private void generateResourcesSapling(Block block, int defaultColor) {
                ResourceLocation cross = ModModelProvider.this.getModelLocation(block, "");
                ResourceLocation crossTinted = ModModelProvider.this.getModelLocation(block, "_layer1");
                TextureMapping textureMapping = new TextureMapping().put(TextureSlot.CROSS, cross).put(CROSS_TINTED_SLOT, crossTinted);
                ResourceLocation blockModel = CROSS_TINTED.create(block, textureMapping, this.modelOutput);
                ResourceLocation itemModel = this.generateLayeredItem(block.asItem(), cross, crossTinted);
                this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)new MultiVariant(WeightedList.of((Object)new Variant(blockModel)))));
                this.itemModelOutput.accept(block.asItem(), ItemModelUtils.tintedModel((ResourceLocation)itemModel, (ItemTintSource[])new ItemTintSource[]{ItemModelUtils.constantTint((int)-1), new ResourcesTypeTintSource(defaultColor)}));
            }

            private ResourceLocation generateLayeredItem(Item p_378743_, ResourceLocation p_377953_, ResourceLocation p_378692_) {
                return ModelTemplates.TWO_LAYERED_ITEM.create(p_378743_, TextureMapping.layered((ResourceLocation)p_377953_, (ResourceLocation)p_378692_), this.modelOutput);
            }

            private void blockWithExistingModel(Block block) {
                this.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)new MultiVariant(WeightedList.of((Object)new Variant(ModModelProvider.this.getModelLocation(block, ""))))));
                this.itemModelOutput.accept(block.asItem(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModModelProvider.this.getModelLocation(block, ""), List.of()));
            }
        };
    }

    protected ItemModelGenerators getItemModelGenerators(ModelProvider.ItemInfoCollector items, ModelProvider.SimpleModelCollector models) {
        return new ItemModelGenerators(this, (ItemModelOutput)items, (BiConsumer)models){

            public void run() {
                this.generateFlatTintedItem((Item)ModItems.LEAF_FRAGMENT.get(), new ResourcesTypeTintSource(-1));
                this.generateTintedEssenceItem((Item)ModItems.FIRE_ESSENCE.get(), ItemModelUtils.constantTint((int)-1813725));
                this.generateTintedEssenceItem((Item)ModItems.WATER_ESSENCE.get(), ItemModelUtils.constantTint((int)-15235116));
                this.generateTintedEssenceItem((Item)ModItems.NATURE_ESSENCE.get(), ItemModelUtils.constantTint((int)-15045112));
                this.generateTintedEssenceItem((Item)ModItems.END_ESSENCE.get(), ItemModelUtils.constantTint((int)-3817845));
            }

            private void generateTintedEssenceItem(Item item, ItemTintSource tintSource) {
                ResourceLocation itemModel = ModelTemplates.FLAT_ITEM.create(item, TextureMapping.layer0((ResourceLocation)ResourcesTrees.id("item/essence")), this.modelOutput);
                this.itemModelOutput.accept(item, ItemModelUtils.tintedModel((ResourceLocation)itemModel, (ItemTintSource[])new ItemTintSource[]{tintSource}));
            }

            private void generateFlatTintedItem(Item item, ItemTintSource tintSource) {
                ResourceLocation itemModel = this.createFlatItemModel(item, ModelTemplates.FLAT_ITEM);
                this.itemModelOutput.accept(item, ItemModelUtils.tintedModel((ResourceLocation)itemModel, (ItemTintSource[])new ItemTintSource[]{tintSource}));
            }
        };
    }

    protected Stream<Item> getKnownItems() {
        return BuiltInRegistries.ITEM.listElements().filter(itemReference -> Optional.of(BuiltInRegistries.ITEM.getKey((Object)((Item)itemReference.value()))).filter(resourceLocation -> resourceLocation.getNamespace().equals("resourcestrees")).isPresent()).map(Holder.Reference::value);
    }

    protected Stream<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.listElements().filter(itemReference -> Optional.of(BuiltInRegistries.BLOCK.getKey((Object)((Block)itemReference.value()))).filter(resourceLocation -> resourceLocation.getNamespace().equals("resourcestrees")).isPresent()).map(Holder.Reference::value);
    }

    private ResourceLocation getModelLocation(Block block, String suffix) {
        return ResourcesTrees.id("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + suffix);
    }
}

