/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.util;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;

public class DataComponentIngredient
extends AbstractIngredient {
    public static final MapCodec<DataComponentIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)HolderSetCodec.create((ResourceKey)Registries.ITEM, (Codec)BuiltInRegistries.ITEM.holderByNameCodec(), (boolean)false).fieldOf("items").forGetter(DataComponentIngredient::itemSet), (App)DataComponentExactPredicate.CODEC.fieldOf("components").forGetter(DataComponentIngredient::components), (App)Codec.BOOL.optionalFieldOf("strict", (Object)false).forGetter(DataComponentIngredient::isStrict)).apply((Applicative)builder, DataComponentIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.ITEM), DataComponentIngredient::itemSet, (StreamCodec)DataComponentExactPredicate.STREAM_CODEC, DataComponentIngredient::components, (StreamCodec)ByteBufCodecs.BOOL, DataComponentIngredient::isStrict, DataComponentIngredient::new);
    private final DataComponentExactPredicate components;
    private final boolean strict;
    private final ItemStack[] stacks;

    protected DataComponentIngredient(HolderSet<Item> p_368516_, DataComponentExactPredicate components, boolean strict) {
        super(p_368516_);
        this.components = components;
        this.strict = strict;
        this.stacks = (ItemStack[])this.values.stream().map(i -> new ItemStack(i, 1, components.asPatch())).toArray(ItemStack[]::new);
    }

    public boolean test(ItemStack stack) {
        if (this.strict) {
            for (ItemStack stack2 : this.stacks) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)stack2)) continue;
                return true;
            }
            return false;
        }
        return this.values.contains(stack.getItemHolder()) && this.components.test((DataComponentGetter)stack);
    }

    public Stream<Holder<Item>> items() {
        return this.values.stream();
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> serializer() {
        return (IIngredientSerializer)ResourcesTrees.DATA_COMPONENT_INGREDIENT.get();
    }

    public SlotDisplay display() {
        return new SlotDisplay.Composite(Stream.of(this.stacks).map(stack -> {
            SlotDisplay.ItemStackSlotDisplay display = new SlotDisplay.ItemStackSlotDisplay(stack);
            ItemStack remainder = stack.getCraftingRemainder();
            if (!remainder.isEmpty()) {
                SlotDisplay.ItemStackSlotDisplay remainderDisplay = new SlotDisplay.ItemStackSlotDisplay(remainder);
                return new SlotDisplay.WithRemainder((SlotDisplay)display, (SlotDisplay)remainderDisplay);
            }
            return display;
        }).toList());
    }

    public HolderSet<Item> itemSet() {
        return this.values;
    }

    public DataComponentExactPredicate components() {
        return this.components;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static DataComponentIngredient of(boolean strict, ItemStack stack) {
        return DataComponentIngredient.of(strict, stack.getComponents(), new ItemLike[]{stack.getItem()});
    }

    public static <T> DataComponentIngredient of(boolean strict, DataComponentType<? super T> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(strict, DataComponentExactPredicate.builder().expect(type, value).build(), items);
    }

    public static <T> DataComponentIngredient of(boolean strict, Supplier<? extends DataComponentType<? super T>> type, T value, ItemLike ... items) {
        return DataComponentIngredient.of(strict, type.get(), value, items);
    }

    public static DataComponentIngredient of(boolean strict, DataComponentMap map, ItemLike ... items) {
        return DataComponentIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), items);
    }

    @SafeVarargs
    public static DataComponentIngredient of(boolean strict, DataComponentMap map, Holder<Item> ... items) {
        return DataComponentIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), items);
    }

    public static DataComponentIngredient of(boolean strict, DataComponentMap map, HolderSet<Item> items) {
        return DataComponentIngredient.of(strict, DataComponentExactPredicate.allOf((DataComponentMap)map), items);
    }

    @SafeVarargs
    public static DataComponentIngredient of(boolean strict, DataComponentExactPredicate predicate, Holder<Item> ... items) {
        return DataComponentIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(items));
    }

    public static DataComponentIngredient of(boolean strict, DataComponentExactPredicate predicate, ItemLike ... items) {
        return DataComponentIngredient.of(strict, predicate, (HolderSet<Item>)HolderSet.direct(Arrays.stream(items).map(ItemLike::asItem).map(Item::builtInRegistryHolder).toList()));
    }

    public static DataComponentIngredient of(boolean strict, DataComponentExactPredicate predicate, HolderSet<Item> items) {
        return new DataComponentIngredient(items, predicate, strict);
    }

    public static class Serializer
    implements IIngredientSerializer<DataComponentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public MapCodec<DataComponentIngredient> codec() {
            return CODEC;
        }

        public void write(RegistryFriendlyByteBuf buffer, DataComponentIngredient value) {
            STREAM_CODEC.encode((Object)buffer, (Object)value);
        }

        public DataComponentIngredient read(RegistryFriendlyByteBuf buffer) {
            return (DataComponentIngredient)((Object)STREAM_CODEC.decode((Object)buffer));
        }
    }
}

