/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.block.entity.renderer.TreeSimulatorBlockEntityRenderer;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.datagen.model.ResourcesTypeTintSource;
import com.coolerpromc.resourcestrees.item.ModCreativeTab;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import com.coolerpromc.resourcestrees.util.DataComponentIngredient;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="resourcestrees")
public final class ResourcesTrees {
    public static final String MODID = "resourcestrees";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<IIngredientSerializer<?>> INGREDIENT_SERIALIZERS = DeferredRegister.create((DeferredRegister.RegistryHolder)ForgeRegistries.INGREDIENT_SERIALIZERS, (String)"resourcestrees");
    public static final RegistryObject<IIngredientSerializer<DataComponentIngredient>> DATA_COMPONENT_INGREDIENT = INGREDIENT_SERIALIZERS.register("data_component", DataComponentIngredient.Serializer::new);

    public ResourcesTrees(FMLJavaModLoadingContext context) {
        BusGroup modBusGroup = context.getModBusGroup();
        EntityJoinLevelEvent.BUS.addListener(ResourcesTrees::onEntityJoinLevel);
        ModItems.register(modBusGroup);
        ModBlocks.register(modBusGroup);
        ModBlockEntities.register(modBusGroup);
        ModCreativeTab.register(modBusGroup);
        ModDataComponents.register(modBusGroup);
        ModMenuTypes.register(modBusGroup);
        ModRecipes.register(modBusGroup);
        INGREDIENT_SERIALIZERS.register(modBusGroup);
    }

    @SubscribeEvent(priority=-127)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Block block;
        if (!ModList.get().isLoaded("treeharvester")) {
            return;
        }
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        ItemStack itemStack = itemEntity.getItem();
        Item item = itemStack.getItem();
        if (!(item instanceof BlockItem) && !(item instanceof LeafFragmentItem)) {
            return;
        }
        if (item instanceof BlockItem && !((block = Block.byItem((Item)item)) instanceof ResourcesSaplingBlock)) {
            return;
        }
        if (!itemStack.has((DataComponentType)ModDataComponents.TYPE.get())) {
            return;
        }
        Holder type = (Holder)itemStack.get((DataComponentType)ModDataComponents.TYPE.get());
        if (type != null) {
            if (itemEntity.isRemoved()) {
                return;
            }
            BlockPos pos = ResourcesTrees.findNearbyBlock((Level)level2, itemEntity.getOnPos(), 5, 50);
            if (pos.equals((Object)BlockPos.ZERO)) {
                return;
            }
            if (!(level2.getBlockState(pos).getBlock() instanceof ResourcesSaplingBlock)) {
                return;
            }
            if (!level2.isLoaded(pos)) {
                return;
            }
            BlockEntity blockEntity = level2.getBlockEntity(pos);
            if (!(blockEntity instanceof ResourcesTypesBlockEntity)) {
                return;
            }
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            be.setResourcesType((ResourcesTypes)type.value());
            List<BlockPos> nearbyPos = ResourcesTrees.findAllNearbyBlock((Level)level2, pos, 1);
            for (BlockPos blockPos : nearbyPos) {
                BlockEntity neighbourBe;
                if (blockPos.equals((Object)pos) || !((neighbourBe = level2.getBlockEntity(blockPos)) instanceof ResourcesTypesBlockEntity)) continue;
                ResourcesTypesBlockEntity be2 = (ResourcesTypesBlockEntity)neighbourBe;
                be2.setResourcesType((ResourcesTypes)type.value());
            }
        }
    }

    public static BlockPos findNearbyBlock(Level level, BlockPos center, int radiusXZ, int radiusY) {
        for (int x = -radiusXZ; x <= radiusXZ; ++x) {
            for (int y = -radiusY; y <= radiusY; ++y) {
                for (int z = -radiusXZ; z <= radiusXZ; ++z) {
                    ResourcesTypesBlockEntity be;
                    BlockEntity entity;
                    BlockPos checkPos = center.offset(x, y, z);
                    if (!(level.getBlockState(checkPos).getBlock() instanceof ResourcesSaplingBlock) || !((entity = level.getBlockEntity(checkPos)) instanceof ResourcesTypesBlockEntity) || (be = (ResourcesTypesBlockEntity)entity).getResourcesType() != null && !Objects.equals(be.getResourcesType(), ResourcesTypes.EMPTY)) continue;
                    return checkPos;
                }
            }
        }
        return BlockPos.ZERO;
    }

    public static List<BlockPos> findAllNearbyBlock(Level level, BlockPos center, int radius) {
        ArrayList<BlockPos> pos = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = center.offset(x, y, z);
                    if (!(level.getBlockState(checkPos).getBlock() instanceof ResourcesSaplingBlock)) continue;
                    pos.add(checkPos);
                }
            }
        }
        return pos;
    }

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    @Mod.EventBusSubscriber(modid="resourcestrees", value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> MenuScreens.register(ModMenuTypes.TREE_SIMULATOR.get(), TreeSimulatorScreen::new));
        }

        @SubscribeEvent
        public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
            ItemTintSources.ID_MAPPER.put((Object)ResourceLocation.fromNamespaceAndPath((String)ResourcesTrees.MODID, (String)"resources_type_tint"), ResourcesTypeTintSource.MAP_CODEC);
            event.register((blockState, blockAndTintGetter, blockPos, i) -> {
                BlockEntity blockEntity;
                if (blockAndTintGetter != null && (blockEntity = blockAndTintGetter.getBlockEntity(blockPos)) instanceof ResourcesTypesBlockEntity) {
                    ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
                    return be.getColor();
                }
                return -12012264;
            }, new Block[]{(Block)ModBlocks.RESOURCES_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), (Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), (Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), (Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), (Block)ModBlocks.RESOURCES_PALE_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), (Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), (Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), (Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get(), (Block)ModBlocks.RESOURCES_PALE_OAK_LEAVES.get()});
        }

        @SubscribeEvent
        public static void onEntityRenderersRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ModBlockEntities.TREE_SIMULATOR_BE.get(), TreeSimulatorBlockEntityRenderer::new);
        }
    }
}

