/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.custom;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.datagen.ModRecipeProvider;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeSimulatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final Map<ResourcesSaplingBlock, Item> LOG_BY_SAPLINGS = Map.of((ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_OAK_SAPLING.get()), Items.OAK_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_SPRUCE_SAPLING.get()), Items.SPRUCE_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_BIRCH_SAPLING.get()), Items.BIRCH_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_JUNGLE_SAPLING.get()), Items.JUNGLE_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_ACACIA_SAPLING.get()), Items.ACACIA_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get()), Items.DARK_OAK_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_CHERRY_SAPLING.get()), Items.CHERRY_LOG, (ResourcesSaplingBlock)((Object)ModBlocks.RESOURCES_PALE_OAK_SAPLING.get()), Items.PALE_OAK_LOG);
    public int growTicks = 0;
    public int maxGrowTicks = 0;
    private final ItemStackHandler inputHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            Optional<RecipeHolder<TreeSimulatorRecipe>> recipeHolder = TreeSimulatorBlockEntity.this.getCurrentRecipe();
            if (recipeHolder.isPresent()) {
                TreeSimulatorRecipe recipe = (TreeSimulatorRecipe)recipeHolder.get().value();
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(recipe.ticksToGrow());
            } else {
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(0);
            }
        }
    };
    private final ItemStackHandler outputHandler = new ItemStackHandler(9);
    private final ItemStackHandler axeHandler = new ItemStackHandler(this, 1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.getItem() instanceof AxeItem;
        }
    };
    private final ContainerData data = new ContainerData(){

        public int get(int i) {
            return switch (i) {
                case 0 -> TreeSimulatorBlockEntity.this.growTicks;
                case 1 -> TreeSimulatorBlockEntity.this.maxGrowTicks;
                default -> 0;
            };
        }

        public void set(int i, int value) {
            switch (i) {
                case 0: {
                    TreeSimulatorBlockEntity.this.growTicks = value;
                    break;
                }
                case 1: {
                    TreeSimulatorBlockEntity.this.maxGrowTicks = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public TreeSimulatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.TREE_SIMULATOR_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Tree Simulator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new TreeSimulatorMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        NonNullList inputStacks = NonNullList.withSize((int)this.inputHandler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inputHandler.getSlots(); ++i) {
            inputStacks.set(i, (Object)this.inputHandler.getStackInSlot(i));
        }
        NonNullList outputStacks = NonNullList.withSize((int)this.outputHandler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            outputStacks.set(i, (Object)this.outputHandler.getStackInSlot(i));
        }
        NonNullList axeStacks = NonNullList.withSize((int)this.axeHandler.getSlots(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.axeHandler.getSlots(); ++i) {
            axeStacks.set(i, (Object)this.axeHandler.getStackInSlot(i));
        }
        ContainerHelper.saveAllItems((ValueOutput)output.child("input"), (NonNullList)inputStacks);
        ContainerHelper.saveAllItems((ValueOutput)output.child("output"), (NonNullList)outputStacks);
        ContainerHelper.saveAllItems((ValueOutput)output.child("axe"), (NonNullList)axeStacks);
        output.putInt("growTicks", this.growTicks);
        output.putInt("maxGrowTicks", this.maxGrowTicks);
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        NonNullList inputStacks = NonNullList.withSize((int)this.inputHandler.getSlots(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("input"), (NonNullList)inputStacks);
        for (int i = 0; i < this.inputHandler.getSlots(); ++i) {
            this.inputHandler.setStackInSlot(i, (ItemStack)inputStacks.get(i));
        }
        NonNullList outputStacks = NonNullList.withSize((int)this.outputHandler.getSlots(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("output"), (NonNullList)outputStacks);
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            this.outputHandler.setStackInSlot(i, (ItemStack)outputStacks.get(i));
        }
        NonNullList axeStacks = NonNullList.withSize((int)this.axeHandler.getSlots(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((ValueInput)input.childOrEmpty("axe"), (NonNullList)axeStacks);
        for (int i = 0; i < this.axeHandler.getSlots(); ++i) {
            this.axeHandler.setStackInSlot(i, (ItemStack)axeStacks.get(i));
        }
        this.data.set(0, input.getIntOr("growTicks", 0));
        this.data.set(1, input.getIntOr("maxGrowTicks", 0));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(ValueInput tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
        this.loadAdditional(tag);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = this.saveWithoutMetadata(registries);
        tag.putInt("growTicks", this.growTicks);
        tag.putInt("maxGrowTicks", this.maxGrowTicks);
        return tag;
    }

    public void onDataPacket(Connection connection, ValueInput data, HolderLookup.Provider lookup) {
        super.onDataPacket(connection, data, lookup);
        this.loadAdditional(data);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (level.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.isAxeValid()) {
            this.increaseGrowTicks();
            TreeSimulatorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.treeGrown()) {
                this.harvest(level);
                this.resetGrowTicks();
            }
        } else {
            this.resetGrowTicks();
        }
        this.setChanged();
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
    }

    private void harvest(Level level) {
        Optional<RecipeHolder<TreeSimulatorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            ItemStack axe;
            Integer damage;
            ArrayList results = new ArrayList();
            ((TreeSimulatorRecipe)recipe.get().value()).drops().forEach(output -> {
                int rolls = output.getRolls(level.random);
                for (int i = 0; i < rolls; ++i) {
                    if (!(level.random.nextFloat() < output.chance())) continue;
                    results.add(output.output().copy());
                }
            });
            if (!this.isAxeUnbreakable() && (damage = (Integer)(axe = this.getAxe()).get(DataComponents.DAMAGE)) != null) {
                axe.set(DataComponents.DAMAGE, (Object)(damage + 1));
            }
            for (ItemStack result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.insertItem(outputSlot, result, false);
                    continue;
                }
                ResourcesTrees.LOGGER.warn("No suitable output slot found for item: {} at {}", (Object)result, (Object)this.getBlockPos());
            }
        }
    }

    private boolean treeGrown() {
        return this.growTicks >= this.maxGrowTicks;
    }

    private void increaseGrowTicks() {
        ++this.growTicks;
    }

    private void resetGrowTicks() {
        this.growTicks = 0;
    }

    private void setMaxGrowTicks(int tick) {
        this.data.set(1, tick);
    }

    private int findSuitableOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<TreeSimulatorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        List<ItemStack> results = ((TreeSimulatorRecipe)recipe.get().value()).drops().stream().map(TreeSimulatorOutput::output).toList();
        for (ItemStack result : results) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result)) continue;
            return false;
        }
        return this.checkSlot(results);
    }

    private boolean checkSlot(List<ItemStack> results) {
        int count = results.size();
        int emptyCount = 0;
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty()) {
                for (ItemStack result : results) {
                    if (stackInSlot.getItem() != result.getItem() || stackInSlot.getCount() + result.getCount() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.getCount() + result.getCount() > stackInSlot.getMaxStackSize())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack item) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.outputHandler.getStackInSlot(i);
            if (!stackInSlot.isEmpty() && !ResourcesTypes.isSameItemSameType(stackInSlot, item)) continue;
            return true;
        }
        return false;
    }

    private Optional<RecipeHolder<TreeSimulatorRecipe>> getCurrentRecipe() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional recipe = serverLevel.recipeAccess().getRecipeFor((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get(), (RecipeInput)new TreeSimulatorRecipeInput(this.getSapling()), (Level)serverLevel);
            if (recipe.isPresent()) {
                return recipe;
            }
            Block block = Block.byItem((Item)this.getSapling().getItem());
            if (block instanceof ResourcesSaplingBlock) {
                ResourcesSaplingBlock block2 = (ResourcesSaplingBlock)block;
                Holder type = (Holder)this.getSapling().get((DataComponentType)ModDataComponents.TYPE.get());
                ItemStack leaf = ((LeafFragmentItem)((Object)ModItems.LEAF_FRAGMENT.get())).getDefaultInstance();
                leaf.set((DataComponentType)ModDataComponents.TYPE.get(), (Object)type);
                if (type != null && type.value() != ResourcesTypes.EMPTY) {
                    ResourcesTypes value = (ResourcesTypes)type.value();
                    ArrayList<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
                    drops.add(TreeSimulatorOutput.of(LOG_BY_SAPLINGS.get((Object)block2).getDefaultInstance(), 1.0f, 2, 4));
                    drops.add(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1));
                    drops.add(TreeSimulatorOutput.of(leaf, value.secondaryDropChance(), 1, 1));
                    drops.add(TreeSimulatorOutput.of(this.getSapling(), value.saplingChance(), 1, 1));
                    drops.add(TreeSimulatorOutput.of(Items.STICK.getDefaultInstance(), 0.1f, 1, 2));
                    drops.add(TreeSimulatorOutput.of(Items.APPLE.getDefaultInstance(), 0.05f, 1, 1));
                    drops.add(TreeSimulatorOutput.of(ModRecipeProvider.SAPLINGS_BY_SAPLINGS.get((Object)block2).getDefaultInstance(), 0.1f, 1, 1));
                    TreeSimulatorRecipe newRecipe = new TreeSimulatorRecipe(this.getSapling(), drops, 1200);
                    ResourceKey key = ResourceKey.create((ResourceKey)Registries.RECIPE, (ResourceLocation)((ResourceKey)type.unwrapKey().get()).location().withSuffix(BuiltInRegistries.BLOCK.getKey((Object)block2).getPath().substring(9)).withPrefix("tree_simulator/"));
                    return Optional.of(new RecipeHolder(key, (Recipe)newRecipe));
                }
            }
        }
        return Optional.empty();
    }

    public ItemStackHandler getInputHandler() {
        return this.inputHandler;
    }

    public ItemStackHandler getOutputHandler() {
        return this.outputHandler;
    }

    public ItemStack getSapling() {
        return this.inputHandler.getStackInSlot(0);
    }

    public ContainerData getData() {
        return this.data;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.DOWN) {
                return LazyOptional.of(() -> this.outputHandler).cast();
            }
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStackHandler getAxeHandler() {
        return this.axeHandler;
    }

    public ItemStack getAxe() {
        return this.axeHandler.getStackInSlot(0);
    }

    public boolean isAxeUnbreakable() {
        return this.getAxe().has(DataComponents.UNBREAKABLE);
    }

    public boolean isAxeValid() {
        ItemStack axe = this.getAxe();
        Integer damage = (Integer)axe.get(DataComponents.DAMAGE);
        Integer maxDamage = (Integer)axe.get(DataComponents.MAX_DAMAGE);
        if (damage != null && maxDamage != null) {
            if (damage >= maxDamage) {
                this.axeHandler.extractItem(0, 1, false);
            }
            return damage < maxDamage || this.isAxeUnbreakable();
        }
        return this.isAxeUnbreakable();
    }
}

