/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.core;

import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.registry.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public record ResourcesTypes(Either<ResourceLocation, TagKey<Item>> material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
    public static final Codec<Either<ResourceLocation, TagKey<Item>>> MATERIAL_CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)TagKey.hashedCodec((ResourceKey)Registries.ITEM));
    public static final Codec<ResourcesTypes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(ResourcesTypes::material), (App)Codec.INT.fieldOf("color").forGetter(ResourcesTypes::color), (App)Codec.STRING.fieldOf("translationKey").forGetter(ResourcesTypes::translationKey), (App)Codec.INT.fieldOf("weight").forGetter(ResourcesTypes::weight), (App)Codec.FLOAT.fieldOf("saplingChance").forGetter(ResourcesTypes::saplingChance), (App)Codec.FLOAT.fieldOf("secondaryDropChance").forGetter(ResourcesTypes::secondaryDropChance)).apply((Applicative)instance, ResourcesTypes::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ResourcesTypes> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either((StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)TagKey.streamCodec((ResourceKey)Registries.ITEM)), ResourcesTypes::material, (StreamCodec)ByteBufCodecs.INT, ResourcesTypes::color, (StreamCodec)ByteBufCodecs.STRING_UTF8, ResourcesTypes::translationKey, (StreamCodec)ByteBufCodecs.INT, ResourcesTypes::weight, (StreamCodec)ByteBufCodecs.FLOAT, ResourcesTypes::saplingChance, (StreamCodec)ByteBufCodecs.FLOAT, ResourcesTypes::secondaryDropChance, ResourcesTypes::new);
    public static final ResourcesTypes EMPTY = new ResourcesTypes(Items.AIR, -15461356, "item.resourcestrees.empty", 0, 0.0f, 0.0f);
    public static final ResourceKey<ResourcesTypes> STONE = ResourcesTypes.register("stone");
    public static final ResourceKey<ResourcesTypes> COAL = ResourcesTypes.register("coal");
    public static final ResourceKey<ResourcesTypes> IRON = ResourcesTypes.register("iron");
    public static final ResourceKey<ResourcesTypes> COPPER = ResourcesTypes.register("copper");
    public static final ResourceKey<ResourcesTypes> GOLD = ResourcesTypes.register("gold");
    public static final ResourceKey<ResourcesTypes> LAPIS = ResourcesTypes.register("lapis");
    public static final ResourceKey<ResourcesTypes> EMERALD = ResourcesTypes.register("emerald");
    public static final ResourceKey<ResourcesTypes> DIAMOND = ResourcesTypes.register("diamond");
    public static final ResourceKey<ResourcesTypes> OBSIDIAN = ResourcesTypes.register("obsidian");
    public static final ResourceKey<ResourcesTypes> AMETHYST = ResourcesTypes.register("amethyst");
    public static final ResourceKey<ResourcesTypes> NETHERITE = ResourcesTypes.register("netherite");
    public static final ResourceKey<ResourcesTypes> WOOD = ResourcesTypes.register("wood");
    public static final ResourceKey<ResourcesTypes> QUARTZ = ResourcesTypes.register("quartz");
    public static final ResourceKey<ResourcesTypes> PRISMARINE = ResourcesTypes.register("prismarine");
    public static final ResourceKey<ResourcesTypes> GLOWSTONE = ResourcesTypes.register("glowstone");
    public static final ResourceKey<ResourcesTypes> REDSTONE = ResourcesTypes.register("redstone");
    public static final ResourceKey<ResourcesTypes> DEEPSLATE = ResourcesTypes.register("deepslate");
    public static final ResourceKey<ResourcesTypes> DIRT = ResourcesTypes.register("dirt");
    public static final ResourceKey<ResourcesTypes> FIRE = ResourcesTypes.register("fire");
    public static final ResourceKey<ResourcesTypes> NETHER = ResourcesTypes.register("nether");
    public static final ResourceKey<ResourcesTypes> END = ResourcesTypes.register("end");
    public static final ResourceKey<ResourcesTypes> NATURE = ResourcesTypes.register("nature");
    public static final ResourceKey<ResourcesTypes> WATER = ResourcesTypes.register("water");
    public static final ResourceKey<ResourcesTypes> ICE = ResourcesTypes.register("ice");

    public ResourcesTypes(Item material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.left((Object)BuiltInRegistries.ITEM.getKey((Object)material)), color, translationKey, weight, saplingChance, secondaryDropChance);
    }

    public ResourcesTypes(TagKey<Item> material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
        this((Either<ResourceLocation, TagKey<Item>>)Either.right(material), color, translationKey, weight, saplingChance, secondaryDropChance);
    }

    private static ResourceKey<ResourcesTypes> register(String name) {
        return ResourceKey.create(ModRegistries.RESOURCES_TYPES_KEY, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"resourcestrees", (String)name));
    }

    public static void bootstrap(BootstrapContext<ResourcesTypes> context) {
        context.register(STONE, (Object)new ResourcesTypes(Items.COBBLESTONE, -11711671, "item.resourcestrees.stone", 5, 0.25f, 0.5f));
        context.register(COAL, (Object)new ResourcesTypes(Items.COAL_BLOCK, -16777216, "item.resourcestrees.coal", 5, 0.25f, 0.5f));
        context.register(IRON, (Object)new ResourcesTypes(Items.IRON_BLOCK, -5194043, "item.resourcestrees.iron", 5, 0.25f, 0.5f));
        context.register(COPPER, (Object)new ResourcesTypes(Items.COPPER_BLOCK, -2855612, "item.resourcestrees.copper", 5, 0.25f, 0.5f));
        context.register(GOLD, (Object)new ResourcesTypes(Items.GOLD_BLOCK, -10752, "item.resourcestrees.gold", 5, 0.25f, 0.5f));
        context.register(LAPIS, (Object)new ResourcesTypes(Items.LAPIS_BLOCK, -12627531, "item.resourcestrees.lapis", 5, 0.25f, 0.5f));
        context.register(EMERALD, (Object)new ResourcesTypes(Items.EMERALD_BLOCK, -16725933, "item.resourcestrees.emerald", 5, 0.25f, 0.5f));
        context.register(DIAMOND, (Object)new ResourcesTypes(Items.DIAMOND_BLOCK, -12532481, "item.resourcestrees.diamond", 3, 0.2f, 0.4f));
        context.register(OBSIDIAN, (Object)new ResourcesTypes(Items.OBSIDIAN, -13755833, "item.resourcestrees.obsidian", 4, 0.25f, 0.5f));
        context.register(AMETHYST, (Object)new ResourcesTypes(Items.AMETHYST_BLOCK, -6543440, "item.resourcestrees.amethyst", 5, 0.25f, 0.5f));
        context.register(NETHERITE, (Object)new ResourcesTypes(Items.NETHERITE_BLOCK, -12698050, "item.resourcestrees.netherite", 2, 0.15f, 0.3f));
        context.register(WOOD, (Object)new ResourcesTypes((TagKey<Item>)ItemTags.LOGS, -7508381, "item.resourcestrees.wood", 5, 0.25f, 0.5f));
        context.register(QUARTZ, (Object)new ResourcesTypes(Items.QUARTZ_BLOCK, -657931, "item.resourcestrees.quartz", 5, 0.25f, 0.5f));
        context.register(PRISMARINE, (Object)new ResourcesTypes(Items.PRISMARINE, -10565432, "item.resourcestrees.prismarine", 5, 0.25f, 0.5f));
        context.register(GLOWSTONE, (Object)new ResourcesTypes(Items.GLOWSTONE, -3722, "item.resourcestrees.glowstone", 5, 0.25f, 0.5f));
        context.register(REDSTONE, (Object)new ResourcesTypes(Items.REDSTONE_BLOCK, -59580, "item.resourcestrees.redstone", 5, 0.25f, 0.5f));
        context.register(DEEPSLATE, (Object)new ResourcesTypes(Items.DEEPSLATE, -13948124, "item.resourcestrees.deepslate", 5, 0.25f, 0.5f));
        context.register(DIRT, (Object)new ResourcesTypes(Items.DIRT, -6588845, "item.resourcestrees.dirt", 5, 0.25f, 0.5f));
        context.register(FIRE, (Object)new ResourcesTypes((Item)ModItems.FIRE_ESSENCE.get(), -1813725, "item.resourcestrees.fire", 5, 0.25f, 0.5f));
        context.register(NETHER, (Object)new ResourcesTypes(Items.NETHERRACK, -11463403, "item.resourcestrees.nether", 5, 0.25f, 0.5f));
        context.register(END, (Object)new ResourcesTypes((Item)ModItems.END_ESSENCE.get(), -3817845, "item.resourcestrees.end", 5, 0.25f, 0.5f));
        context.register(NATURE, (Object)new ResourcesTypes((Item)ModItems.NATURE_ESSENCE.get(), -15045112, "item.resourcestrees.nature", 5, 0.25f, 0.5f));
        context.register(WATER, (Object)new ResourcesTypes((Item)ModItems.WATER_ESSENCE.get(), -15235116, "item.resourcestrees.water", 5, 0.25f, 0.5f));
        context.register(ICE, (Object)new ResourcesTypes(Items.ICE, -4593430, "item.resourcestrees.ice", 5, 0.25f, 0.5f));
    }

    public static Map<ResourceLocation, Holder<ResourcesTypes>> getAllResourcesTypes(HolderLookup.Provider provider) {
        Stream registry = provider.lookupOrThrow(ModRegistries.RESOURCES_TYPES_KEY).listElements();
        HashMap<ResourceLocation, Holder<ResourcesTypes>> types = new HashMap<ResourceLocation, Holder<ResourcesTypes>>();
        registry.forEachOrdered(entry -> {
            if (types.containsKey(entry.key().location())) {
                throw new IllegalStateException("Duplicate resource index " + String.valueOf(entry.key().location()) + " for " + String.valueOf(entry.key().location()));
            }
            types.put(entry.key().location(), (Holder<ResourcesTypes>)entry);
        });
        return types;
    }

    public Holder<ResourcesTypes> asHolder(Level level) {
        return ResourcesTypes.getAllResourcesTypes((HolderLookup.Provider)level.registryAccess()).values().stream().filter(holder -> ((ResourcesTypes)holder.value()).equals(this)).findFirst().get();
    }

    public boolean isEmpty() {
        return this.equals(EMPTY);
    }

    public static boolean isSameItemSameType(ItemStack stack, ItemStack other) {
        if (!ItemStack.isSameItem((ItemStack)stack, (ItemStack)other)) {
            return false;
        }
        boolean hasType1 = stack.has((DataComponentType)ModDataComponents.TYPE.get());
        boolean hasType2 = other.has((DataComponentType)ModDataComponents.TYPE.get());
        if (hasType1 && hasType2) {
            return Objects.equals(stack.get((DataComponentType)ModDataComponents.TYPE.get()), other.get((DataComponentType)ModDataComponents.TYPE.get()));
        }
        return !hasType1 && !hasType2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourcesTypes that = (ResourcesTypes)o;
        return this.color() == that.color() && this.weight() == that.weight() && Float.compare(this.saplingChance(), that.saplingChance()) == 0 && Float.compare(this.secondaryDropChance(), that.secondaryDropChance()) == 0 && Objects.equals(this.translationKey(), that.translationKey()) && Objects.equals(this.material(), that.material());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.material(), this.color(), this.translationKey(), this.weight(), Float.valueOf(this.saplingChance()), Float.valueOf(this.secondaryDropChance()));
    }
}

