/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.entity.custom;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.datagen.ModRecipeProvider;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.input.TreeSimulatorRecipeInput;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorMenu;
import com.coolerpromc.resourcestrees.util.ExtendedSimpleInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class TreeSimulatorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
class_1278 {
    public static final Map<ResourcesSaplingBlock, class_1792> LOG_BY_SAPLINGS = Map.of(ModBlocks.RESOURCES_OAK_SAPLING, class_1802.field_8583, ModBlocks.RESOURCES_SPRUCE_SAPLING, class_1802.field_8684, ModBlocks.RESOURCES_BIRCH_SAPLING, class_1802.field_8170, ModBlocks.RESOURCES_JUNGLE_SAPLING, class_1802.field_8125, ModBlocks.RESOURCES_ACACIA_SAPLING, class_1802.field_8820, ModBlocks.RESOURCES_DARK_OAK_SAPLING, class_1802.field_8652, ModBlocks.RESOURCES_CHERRY_SAPLING, class_1802.field_42692);
    public int growTicks = 0;
    public int maxGrowTicks = 0;
    private final ExtendedSimpleInventory inputHandler = new ExtendedSimpleInventory(1){

        public void method_5447(int slot, class_1799 stack) {
            super.method_5447(slot, stack);
            Optional<class_8786<TreeSimulatorRecipe>> recipeHolder = TreeSimulatorBlockEntity.this.getCurrentRecipe();
            if (recipeHolder.isPresent()) {
                TreeSimulatorRecipe recipe = (TreeSimulatorRecipe)recipeHolder.get().comp_1933();
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(recipe.ticksToGrow());
            } else {
                TreeSimulatorBlockEntity.this.setMaxGrowTicks(0);
            }
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }
    };
    private final ExtendedSimpleInventory outputHandler = new ExtendedSimpleInventory(this, 9){

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return false;
        }
    };
    private final ExtendedSimpleInventory axeHandler = new ExtendedSimpleInventory(this, 1){

        public boolean method_5437(int slot, class_1799 stack) {
            return stack.method_7909() instanceof class_1743;
        }

        @Override
        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return false;
        }

        @Override
        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }
    };
    private final class_3913 data = new class_3913(){

        public int method_17390(int i) {
            return switch (i) {
                case 0 -> TreeSimulatorBlockEntity.this.growTicks;
                case 1 -> TreeSimulatorBlockEntity.this.maxGrowTicks;
                default -> 0;
            };
        }

        public void method_17391(int i, int value) {
            switch (i) {
                case 0: {
                    TreeSimulatorBlockEntity.this.growTicks = value;
                    break;
                }
                case 1: {
                    TreeSimulatorBlockEntity.this.maxGrowTicks = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public TreeSimulatorBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.TREE_SIMULATOR_BE, pos, blockState);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Tree Simulator");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new TreeSimulatorMenu(syncId, playerInventory, this, this.data);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_2487 inputNbt = new class_2487();
        class_1262.method_5426((class_2487)inputNbt, (class_2371)this.inputHandler.method_54454(), (class_7225.class_7874)registryLookup);
        nbt.method_10566("input", (class_2520)inputNbt);
        class_2487 outputNbt = new class_2487();
        class_1262.method_5426((class_2487)outputNbt, (class_2371)this.outputHandler.method_54454(), (class_7225.class_7874)registryLookup);
        nbt.method_10566("output", (class_2520)outputNbt);
        class_2487 axeNbt = new class_2487();
        class_1262.method_5426((class_2487)axeNbt, (class_2371)this.axeHandler.method_54454(), (class_7225.class_7874)registryLookup);
        nbt.method_10566("axe", (class_2520)axeNbt);
        nbt.method_10569("growTicks", this.growTicks);
        nbt.method_10569("maxGrowTicks", this.maxGrowTicks);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt.method_10562("input"), (class_2371)this.inputHandler.method_54454(), (class_7225.class_7874)registryLookup);
        class_1262.method_5429((class_2487)nbt.method_10562("output"), (class_2371)this.outputHandler.method_54454(), (class_7225.class_7874)registryLookup);
        class_1262.method_5429((class_2487)nbt.method_10562("axe"), (class_2371)this.axeHandler.method_54454(), (class_7225.class_7874)registryLookup);
        this.data.method_17391(0, nbt.method_10550("growTicks"));
        this.data.method_17391(1, nbt.method_10550("maxGrowTicks"));
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 tag = super.method_16887(registries);
        tag.method_10569("growTicks", this.growTicks);
        tag.method_10569("maxGrowTicks", this.maxGrowTicks);
        return tag;
    }

    public void tick(class_1937 level, class_2338 pos, class_2680 state) {
        if (level.method_8608()) {
            return;
        }
        if (this.hasRecipe() && this.isAxeValid()) {
            this.increaseGrowTicks();
            TreeSimulatorBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
            if (this.treeGrown()) {
                this.harvest(level);
                this.resetGrowTicks();
            }
        } else {
            this.resetGrowTicks();
        }
        this.method_5431();
        level.method_8413(pos, this.method_11010(), this.method_11010(), 2);
    }

    private void harvest(class_1937 level) {
        Optional<class_8786<TreeSimulatorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isPresent()) {
            class_1799 axe;
            Integer damage;
            ArrayList results = new ArrayList();
            ((TreeSimulatorRecipe)recipe.get().comp_1933()).drops().forEach(output -> {
                int rolls = output.getRolls(level.field_9229);
                for (int i = 0; i < rolls; ++i) {
                    if (!(level.field_9229.method_43057() < output.chance())) continue;
                    results.add(output.output().method_7972());
                }
            });
            if (!this.isAxeUnbreakable() && (damage = (Integer)(axe = this.getAxe()).method_57824(class_9334.field_49629)) != null) {
                axe.method_57379(class_9334.field_49629, (Object)(damage + 1));
            }
            for (class_1799 result : results) {
                int outputSlot = this.findSuitableOutputSlot(result);
                if (outputSlot != -1) {
                    this.outputHandler.insertItem(outputSlot, result, false);
                    continue;
                }
                ResourcesTrees.LOGGER.warn("No suitable output slot found for item: {} at {}", (Object)result, (Object)this.method_11016());
            }
        }
    }

    private boolean treeGrown() {
        return this.growTicks >= this.maxGrowTicks;
    }

    private void increaseGrowTicks() {
        ++this.growTicks;
    }

    private void resetGrowTicks() {
        this.growTicks = 0;
    }

    private void setMaxGrowTicks(int tick) {
        this.data.method_17391(1, tick);
    }

    private int findSuitableOutputSlot(class_1799 result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            class_1799 stackInSlot = this.outputHandler.method_5438(i);
            if (!stackInSlot.method_7960() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.method_7947() + result.method_7947() > stackInSlot.method_7914())) continue;
            return i;
        }
        return -1;
    }

    private boolean hasRecipe() {
        Optional<class_8786<TreeSimulatorRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        List<class_1799> results = ((TreeSimulatorRecipe)recipe.get().comp_1933()).drops().stream().map(TreeSimulatorOutput::output).toList();
        for (class_1799 result : results) {
            if (this.canInsertAmountIntoOutputSlot(result) && this.canInsertItemIntoOutputSlot(result)) continue;
            return false;
        }
        return this.checkSlot(results);
    }

    private boolean checkSlot(List<class_1799> results) {
        int count = results.size();
        int emptyCount = 0;
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            class_1799 stackInSlot = this.outputHandler.method_5438(i);
            if (!stackInSlot.method_7960()) {
                for (class_1799 result : results) {
                    if (stackInSlot.method_7909() != result.method_7909() || stackInSlot.method_7947() + result.method_7947() > 64) continue;
                    ++emptyCount;
                }
                continue;
            }
            ++emptyCount;
        }
        return emptyCount >= count;
    }

    private boolean canInsertAmountIntoOutputSlot(class_1799 result) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            class_1799 stackInSlot = this.outputHandler.method_5438(i);
            if (!stackInSlot.method_7960() && (!ResourcesTypes.isSameItemSameType(stackInSlot, result) || stackInSlot.method_7947() + result.method_7947() > stackInSlot.method_7914())) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertItemIntoOutputSlot(class_1799 item) {
        for (int i = 0; i < this.outputHandler.getSlots(); ++i) {
            class_1799 stackInSlot = this.outputHandler.method_5438(i);
            if (!stackInSlot.method_7960() && !ResourcesTypes.isSameItemSameType(stackInSlot, item)) continue;
            return true;
        }
        return false;
    }

    private Optional<class_8786<TreeSimulatorRecipe>> getCurrentRecipe() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            Optional recipe = serverLevel.method_8433().method_8132(ModRecipes.TREE_SIMULATOR_TYPE, (class_9695)new TreeSimulatorRecipeInput(this.getSapling()), (class_1937)serverLevel);
            if (recipe.isPresent()) {
                return recipe;
            }
            class_2248 class_22482 = class_2248.method_9503((class_1792)this.getSapling().method_7909());
            if (class_22482 instanceof ResourcesSaplingBlock) {
                ResourcesSaplingBlock block = (ResourcesSaplingBlock)class_22482;
                class_2960 type = (class_2960)this.getSapling().method_57824(ModDataComponents.TYPE);
                ResourcesTypes value = ResourcesTypes.byId(type, (class_1937)serverLevel);
                class_1799 leaf = ModItems.LEAF_FRAGMENT.method_7854();
                leaf.method_57379(ModDataComponents.TYPE, (Object)type);
                if (value != ResourcesTypes.EMPTY && type != null) {
                    ArrayList<TreeSimulatorOutput> drops = new ArrayList<TreeSimulatorOutput>();
                    drops.add(TreeSimulatorOutput.of(LOG_BY_SAPLINGS.get((Object)block).method_7854(), 1.0f, 2, 4));
                    drops.add(TreeSimulatorOutput.of(leaf, 1.0f, 1, 1));
                    drops.add(TreeSimulatorOutput.of(leaf, value.secondaryDropChance(), 1, 1));
                    drops.add(TreeSimulatorOutput.of(this.getSapling(), value.saplingChance(), 1, 1));
                    drops.add(TreeSimulatorOutput.of(class_1802.field_8600.method_7854(), 0.1f, 1, 2));
                    drops.add(TreeSimulatorOutput.of(class_1802.field_8279.method_7854(), 0.05f, 1, 1));
                    drops.add(TreeSimulatorOutput.of(ModRecipeProvider.SAPLINGS_BY_SAPLINGS.get((Object)block).method_7854(), 0.1f, 1, 1));
                    TreeSimulatorRecipe newRecipe = new TreeSimulatorRecipe(this.getSapling(), drops, 1200);
                    class_5321 key = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)type.method_48331(class_7923.field_41175.method_10221((Object)block).method_12832().substring(9)).method_45138("tree_simulator/"));
                    return Optional.of(new class_8786(key.method_29177(), (class_1860)newRecipe));
                }
            }
        }
        return Optional.empty();
    }

    public ExtendedSimpleInventory getInputHandler() {
        return this.inputHandler;
    }

    public ExtendedSimpleInventory getOutputHandler() {
        return this.outputHandler;
    }

    public class_1799 getSapling() {
        return this.inputHandler.method_5438(0);
    }

    public class_3913 getData() {
        return this.data;
    }

    public ExtendedSimpleInventory getAxeHandler() {
        return this.axeHandler;
    }

    public class_1799 getAxe() {
        return this.axeHandler.method_5438(0);
    }

    public boolean isAxeUnbreakable() {
        return this.getAxe().method_57826(class_9334.field_49630);
    }

    public boolean isAxeValid() {
        class_1799 axe = this.getAxe();
        Integer damage = (Integer)axe.method_57824(class_9334.field_49629);
        Integer maxDamage = (Integer)axe.method_57824(class_9334.field_50072);
        if (damage != null && maxDamage != null) {
            if (damage >= maxDamage) {
                this.axeHandler.method_5434(0, 1);
            }
            return damage < maxDamage || this.isAxeUnbreakable();
        }
        return this.isAxeUnbreakable();
    }

    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return IntStream.range(this.inputHandler.method_5439(), this.inputHandler.method_5439() + this.outputHandler.method_5439()).toArray();
        }
        return IntStream.range(0, this.inputHandler.method_5439()).toArray();
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return this.inputHandler.method_5492(slot, stack, dir);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return this.outputHandler.method_5493(slot, stack, dir);
    }

    public int method_5439() {
        return this.inputHandler.method_5439() + this.outputHandler.method_5439() + this.axeHandler.method_5439();
    }

    public boolean method_5442() {
        return this.inputHandler.method_5442() && this.outputHandler.method_5442() && this.axeHandler.method_5442();
    }

    public class_1799 method_5438(int slot) {
        return this.getHandlerForSlot(slot).method_5438(this.getLocalSlot(slot));
    }

    public class_1799 method_5434(int slot, int amount) {
        return this.getHandlerForSlot(slot).method_5434(this.getLocalSlot(slot), amount);
    }

    public class_1799 method_5441(int slot) {
        return this.getHandlerForSlot(slot).method_5441(this.getLocalSlot(slot));
    }

    public void method_5447(int slot, class_1799 stack) {
        this.getHandlerForSlot(slot).method_5447(this.getLocalSlot(slot), stack);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.inputHandler.method_5448();
        this.outputHandler.method_5448();
        this.axeHandler.method_5448();
    }

    private class_1263 getHandlerForSlot(int slot) {
        if (slot < this.inputHandler.method_5439()) {
            return this.inputHandler;
        }
        if ((slot -= this.inputHandler.method_5439()) < this.outputHandler.method_5439()) {
            return this.outputHandler;
        }
        slot -= this.outputHandler.method_5439();
        return this.axeHandler;
    }

    private int getLocalSlot(int globalSlot) {
        if (globalSlot < this.inputHandler.method_5439()) {
            return globalSlot;
        }
        if ((globalSlot -= this.inputHandler.method_5439()) < this.outputHandler.method_5439()) {
            return globalSlot;
        }
        return globalSlot -= this.outputHandler.method_5439();
    }
}

