/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.core;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.registry.ModRegistries;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record ResourcesTypes(Either<class_2960, class_6862<class_1792>> material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
    public static final Map<class_2960, ResourcesTypes> LOADED_TYPES = new HashMap<class_2960, ResourcesTypes>();
    public static final Codec<Either<class_2960, class_6862<class_1792>>> MATERIAL_CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)class_6862.method_40093((class_5321)class_7924.field_41197));
    public static final Codec<ResourcesTypes> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MATERIAL_CODEC.fieldOf("material").forGetter(ResourcesTypes::material), (App)Codec.INT.fieldOf("color").forGetter(ResourcesTypes::color), (App)Codec.STRING.fieldOf("translationKey").forGetter(ResourcesTypes::translationKey), (App)Codec.INT.fieldOf("weight").forGetter(ResourcesTypes::weight), (App)Codec.FLOAT.fieldOf("saplingChance").forGetter(ResourcesTypes::saplingChance), (App)Codec.FLOAT.fieldOf("secondaryDropChance").forGetter(ResourcesTypes::secondaryDropChance)).apply((Applicative)instance, ResourcesTypes::new));
    public static final ResourcesTypes EMPTY = new ResourcesTypes(class_1802.field_8162, -15461356, "item.resourcestrees.empty", 0, 0.0f, 0.0f);
    public static final class_5321<ResourcesTypes> STONE = ResourcesTypes.register("stone");
    public static final class_5321<ResourcesTypes> COAL = ResourcesTypes.register("coal");
    public static final class_5321<ResourcesTypes> IRON = ResourcesTypes.register("iron");
    public static final class_5321<ResourcesTypes> COPPER = ResourcesTypes.register("copper");
    public static final class_5321<ResourcesTypes> GOLD = ResourcesTypes.register("gold");
    public static final class_5321<ResourcesTypes> LAPIS = ResourcesTypes.register("lapis");
    public static final class_5321<ResourcesTypes> EMERALD = ResourcesTypes.register("emerald");
    public static final class_5321<ResourcesTypes> DIAMOND = ResourcesTypes.register("diamond");
    public static final class_5321<ResourcesTypes> OBSIDIAN = ResourcesTypes.register("obsidian");
    public static final class_5321<ResourcesTypes> AMETHYST = ResourcesTypes.register("amethyst");
    public static final class_5321<ResourcesTypes> NETHERITE = ResourcesTypes.register("netherite");
    public static final class_5321<ResourcesTypes> WOOD = ResourcesTypes.register("wood");
    public static final class_5321<ResourcesTypes> QUARTZ = ResourcesTypes.register("quartz");
    public static final class_5321<ResourcesTypes> PRISMARINE = ResourcesTypes.register("prismarine");
    public static final class_5321<ResourcesTypes> GLOWSTONE = ResourcesTypes.register("glowstone");
    public static final class_5321<ResourcesTypes> REDSTONE = ResourcesTypes.register("redstone");
    public static final class_5321<ResourcesTypes> DEEPSLATE = ResourcesTypes.register("deepslate");
    public static final class_5321<ResourcesTypes> DIRT = ResourcesTypes.register("dirt");
    public static final class_5321<ResourcesTypes> FIRE = ResourcesTypes.register("fire");
    public static final class_5321<ResourcesTypes> NETHER = ResourcesTypes.register("nether");
    public static final class_5321<ResourcesTypes> END = ResourcesTypes.register("end");
    public static final class_5321<ResourcesTypes> NATURE = ResourcesTypes.register("nature");
    public static final class_5321<ResourcesTypes> WATER = ResourcesTypes.register("water");
    public static final class_5321<ResourcesTypes> ICE = ResourcesTypes.register("ice");

    public ResourcesTypes(class_1792 material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
        this((Either<class_2960, class_6862<class_1792>>)Either.left((Object)class_7923.field_41178.method_10221((Object)material)), color, translationKey, weight, saplingChance, secondaryDropChance);
    }

    public ResourcesTypes(class_6862<class_1792> material, int color, String translationKey, int weight, float saplingChance, float secondaryDropChance) {
        this((Either<class_2960, class_6862<class_1792>>)Either.right(material), color, translationKey, weight, saplingChance, secondaryDropChance);
    }

    private static class_5321<ResourcesTypes> register(String name) {
        return class_5321.method_29179(ModRegistries.RESOURCES_TYPES_KEY, (class_2960)ResourcesTrees.id(name));
    }

    public static void bootstrap(class_7891<ResourcesTypes> context) {
        context.method_46838(STONE, (Object)new ResourcesTypes(class_1802.field_20412, -11711671, "item.resourcestrees.stone", 5, 0.25f, 0.5f));
        context.method_46838(COAL, (Object)new ResourcesTypes(class_1802.field_8797, -16777216, "item.resourcestrees.coal", 5, 0.25f, 0.5f));
        context.method_46838(IRON, (Object)new ResourcesTypes(class_1802.field_8773, -5194043, "item.resourcestrees.iron", 5, 0.25f, 0.5f));
        context.method_46838(COPPER, (Object)new ResourcesTypes(class_1802.field_27071, -2855612, "item.resourcestrees.copper", 5, 0.25f, 0.5f));
        context.method_46838(GOLD, (Object)new ResourcesTypes(class_1802.field_8494, -10752, "item.resourcestrees.gold", 5, 0.25f, 0.5f));
        context.method_46838(LAPIS, (Object)new ResourcesTypes(class_1802.field_8055, -12627531, "item.resourcestrees.lapis", 5, 0.25f, 0.5f));
        context.method_46838(EMERALD, (Object)new ResourcesTypes(class_1802.field_8733, -16725933, "item.resourcestrees.emerald", 5, 0.25f, 0.5f));
        context.method_46838(DIAMOND, (Object)new ResourcesTypes(class_1802.field_8603, -12532481, "item.resourcestrees.diamond", 3, 0.2f, 0.4f));
        context.method_46838(OBSIDIAN, (Object)new ResourcesTypes(class_1802.field_8281, -13755833, "item.resourcestrees.obsidian", 4, 0.25f, 0.5f));
        context.method_46838(AMETHYST, (Object)new ResourcesTypes(class_1802.field_27064, -6543440, "item.resourcestrees.amethyst", 5, 0.25f, 0.5f));
        context.method_46838(NETHERITE, (Object)new ResourcesTypes(class_1802.field_22018, -12698050, "item.resourcestrees.netherite", 2, 0.15f, 0.3f));
        context.method_46838(WOOD, (Object)new ResourcesTypes((class_6862<class_1792>)class_3489.field_15539, -7508381, "item.resourcestrees.wood", 5, 0.25f, 0.5f));
        context.method_46838(QUARTZ, (Object)new ResourcesTypes(class_1802.field_20402, -657931, "item.resourcestrees.quartz", 5, 0.25f, 0.5f));
        context.method_46838(PRISMARINE, (Object)new ResourcesTypes(class_1802.field_20404, -10565432, "item.resourcestrees.prismarine", 5, 0.25f, 0.5f));
        context.method_46838(GLOWSTONE, (Object)new ResourcesTypes(class_1802.field_8801, -3722, "item.resourcestrees.glowstone", 5, 0.25f, 0.5f));
        context.method_46838(REDSTONE, (Object)new ResourcesTypes(class_1802.field_8793, -59580, "item.resourcestrees.redstone", 5, 0.25f, 0.5f));
        context.method_46838(DEEPSLATE, (Object)new ResourcesTypes(class_1802.field_28866, -13948124, "item.resourcestrees.deepslate", 5, 0.25f, 0.5f));
        context.method_46838(DIRT, (Object)new ResourcesTypes(class_1802.field_8831, -6588845, "item.resourcestrees.dirt", 5, 0.25f, 0.5f));
        context.method_46838(FIRE, (Object)new ResourcesTypes(ModItems.FIRE_ESSENCE, -1813725, "item.resourcestrees.fire", 5, 0.25f, 0.5f));
        context.method_46838(NETHER, (Object)new ResourcesTypes(class_1802.field_8328, -11463403, "item.resourcestrees.nether", 5, 0.25f, 0.5f));
        context.method_46838(END, (Object)new ResourcesTypes(ModItems.END_ESSENCE, -3817845, "item.resourcestrees.end", 5, 0.25f, 0.5f));
        context.method_46838(NATURE, (Object)new ResourcesTypes(ModItems.NATURE_ESSENCE, -15045112, "item.resourcestrees.nature", 5, 0.25f, 0.5f));
        context.method_46838(WATER, (Object)new ResourcesTypes(ModItems.WATER_ESSENCE, -15235116, "item.resourcestrees.water", 5, 0.25f, 0.5f));
        context.method_46838(ICE, (Object)new ResourcesTypes(class_1802.field_8426, -4593430, "item.resourcestrees.ice", 5, 0.25f, 0.5f));
    }

    public static Map<class_2960, ResourcesTypes> getAllResourcesTypes(class_1937 level) {
        class_2378 registry = level.method_30349().method_30530(ModRegistries.RESOURCES_TYPES_KEY);
        HashMap<class_2960, ResourcesTypes> types = new HashMap<class_2960, ResourcesTypes>();
        registry.method_29722().forEach(entry -> {
            if (types.containsKey(((class_5321)entry.getKey()).method_29177())) {
                throw new IllegalStateException("Duplicate resource location " + String.valueOf(((class_5321)entry.getKey()).method_29177()) + " for " + String.valueOf(((class_5321)entry.getKey()).method_29177()));
            }
            types.put(((class_5321)entry.getKey()).method_29177(), (ResourcesTypes)entry.getValue());
        });
        return types;
    }

    public static Map<class_2960, ResourcesTypes> getAllResourcesTypes(class_7225.class_7874 provider) {
        Stream registry = provider.method_46762(ModRegistries.RESOURCES_TYPES_KEY).method_42017();
        HashMap<class_2960, ResourcesTypes> types = new HashMap<class_2960, ResourcesTypes>();
        registry.forEachOrdered(entry -> {
            if (types.containsKey(entry.method_40237().method_29177())) {
                throw new IllegalStateException("Duplicate resource index " + String.valueOf(entry.method_40237().method_29177()) + " for " + String.valueOf(entry.method_40237().method_29177()));
            }
            types.put(entry.method_40237().method_29177(), (ResourcesTypes)entry.comp_349());
        });
        ResourcesTrees.LOGGER.debug("Getting all resources types: {}", types);
        return types;
    }

    public static ResourcesTypes byId(class_2960 id, @Nullable class_1937 level) {
        if (LOADED_TYPES.isEmpty() && level != null) {
            return ResourcesTypes.getAllResourcesTypes(level).getOrDefault(id, EMPTY);
        }
        return LOADED_TYPES.getOrDefault(id, EMPTY);
    }

    public static boolean isSameItemSameType(class_1799 stack, class_1799 other) {
        if (!class_1799.method_7984((class_1799)stack, (class_1799)other)) {
            return false;
        }
        boolean hasType1 = stack.method_57826(ModDataComponents.TYPE);
        boolean hasType2 = other.method_57826(ModDataComponents.TYPE);
        if (hasType1 && hasType2) {
            return Objects.equals(stack.method_57824(ModDataComponents.TYPE), other.method_57824(ModDataComponents.TYPE));
        }
        return !hasType1 && !hasType2;
    }
}

