/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen.recipebuilder;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7800;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_8957;
import org.jetbrains.annotations.Nullable;

public class ExtendedShapedRecipeBuilder
implements class_5797 {
    private final class_7800 category;
    private final class_1792 output;
    private final int count;
    private final class_1799 resultStack;
    private final List<String> pattern = Lists.newArrayList();
    private final Map<Character, class_1856> inputs = Maps.newLinkedHashMap();
    private final Map<String, class_175<?>> criteria = new LinkedHashMap();
    @Nullable
    private String group;
    private boolean showNotification = true;

    private ExtendedShapedRecipeBuilder(class_7800 category, class_1935 output, int count) {
        this(category, new class_1799(output, count));
    }

    private ExtendedShapedRecipeBuilder(class_7800 category, class_1799 result) {
        this.category = category;
        this.output = result.method_7909();
        this.count = result.method_7947();
        this.resultStack = result;
    }

    public static ExtendedShapedRecipeBuilder create(class_7800 category, class_1935 output) {
        return ExtendedShapedRecipeBuilder.create(category, output, 1);
    }

    public static ExtendedShapedRecipeBuilder create(class_7800 category, class_1935 output, int count) {
        return new ExtendedShapedRecipeBuilder(category, output, count);
    }

    public static ExtendedShapedRecipeBuilder create(class_7800 p_251325_, class_1799 result) {
        return new ExtendedShapedRecipeBuilder(p_251325_, result);
    }

    public ExtendedShapedRecipeBuilder input(Character c, class_6862<class_1792> tag) {
        return this.input(c, class_1856.method_8106(tag));
    }

    public ExtendedShapedRecipeBuilder input(Character c, class_1935 item) {
        return this.input(c, class_1856.method_8091((class_1935[])new class_1935[]{item}));
    }

    public ExtendedShapedRecipeBuilder input(Character c, class_1856 ingredient) {
        if (this.inputs.containsKey(c)) {
            throw new IllegalArgumentException("Symbol '" + c + "' is already defined!");
        }
        if (c.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.inputs.put(c, ingredient);
        return this;
    }

    public ExtendedShapedRecipeBuilder pattern(String patternStr) {
        if (!this.pattern.isEmpty() && patternStr.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternStr);
        return this;
    }

    public ExtendedShapedRecipeBuilder criterion(String string, class_175<?> advancementCriterion) {
        this.criteria.put(string, advancementCriterion);
        return this;
    }

    public ExtendedShapedRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public ExtendedShapedRecipeBuilder showNotification(boolean showNotification) {
        this.showNotification = showNotification;
        return this;
    }

    public class_1792 method_36441() {
        return this.output;
    }

    public void method_17972(class_8790 exporter, class_2960 recipeId) {
        class_8957 rawShapedRecipe = this.validate(recipeId);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        Map<String, class_175<?>> var10000 = this.criteria;
        Objects.requireNonNull(builder);
        var10000.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        class_1869 shapedRecipe = new class_1869(Objects.requireNonNullElse(this.group, ""), class_5797.method_55308((class_7800)this.category), rawShapedRecipe, this.resultStack, this.showNotification);
        exporter.method_53819(recipeId, (class_1860)shapedRecipe, builder.method_695(recipeId.method_45138("recipes/" + this.category.method_46203() + "/")));
    }

    private class_8957 validate(class_2960 recipeKey) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeKey));
        }
        return class_8957.method_55085(this.inputs, this.pattern);
    }
}

