/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.compat.jei;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.compat.jei.category.TreeSimulatorCategory;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.event.ModRecipeReceived;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import com.coolerpromc.resourcestrees.util.RecipeViewerFiller;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.common.util.RegistryUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class ModJEIPlugin
implements IModPlugin {
    public Identifier getPluginUid() {
        return Identifier.fromNamespaceAndPath((String)"resourcestrees", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new TreeSimulatorCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addCraftingStation(TreeSimulatorCategory.TREE_SIMULATOR_TYPE, new ItemLike[]{ModBlocks.TREE_SIMULATOR});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<RecipeHolder<TreeSimulatorRecipe>> treeSimulatorRecipe = new ArrayList<RecipeHolder<TreeSimulatorRecipe>>(ModRecipeReceived.recipeMap.byType((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get()));
        List<ResourceKey<Recipe<?>>> keys = treeSimulatorRecipe.stream().map(RecipeHolder::id).toList();
        treeSimulatorRecipe.addAll(RecipeViewerFiller.addUndefinedRecipes((HolderLookup.Provider)RegistryUtil.getRegistryAccess(), keys));
        registration.addRecipes(TreeSimulatorCategory.TREE_SIMULATOR_TYPE, treeSimulatorRecipe.stream().toList());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_OAK_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_SPRUCE_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_BIRCH_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_JUNGLE_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_ACACIA_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_DARK_OAK_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_CHERRY_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_PALE_OAK_SAPLING.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_OAK_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_SPRUCE_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_BIRCH_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_JUNGLE_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_ACACIA_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_DARK_OAK_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_CHERRY_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes(ModBlocks.RESOURCES_PALE_OAK_LEAVES.asItem(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
        registration.registerFromDataComponentTypes((Item)ModItems.LEAF_FRAGMENT.get(), new DataComponentType[]{(DataComponentType)ModDataComponents.TYPE.get()});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(TreeSimulatorScreen.class, 59, 35, 22, 16, new IRecipeType[]{TreeSimulatorCategory.TREE_SIMULATOR_TYPE});
    }
}

