/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.compat.jei.category;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.recipe.ModRecipes;
import com.coolerpromc.resourcestrees.recipe.custom.TreeSimulatorRecipe;
import com.coolerpromc.resourcestrees.recipe.output.TreeSimulatorOutput;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.AbstractRecipeCategory;
import mezz.jei.api.recipe.types.IRecipeHolderType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class TreeSimulatorCategory
extends AbstractRecipeCategory<RecipeHolder<TreeSimulatorRecipe>> {
    public static final Identifier UID = ResourcesTrees.id("dna_extracting");
    public static final Identifier TEXTURE = ResourcesTrees.id("textures/gui/tree_simulator.png");
    public static final IRecipeHolderType<TreeSimulatorRecipe> TREE_SIMULATOR_TYPE = IRecipeHolderType.create((RecipeType)((RecipeType)ModRecipes.TREE_SIMULATOR_TYPE.get()));
    private int tickCount = 0;

    public TreeSimulatorCategory(IGuiHelper helper) {
        super(TREE_SIMULATOR_TYPE, (Component)Component.translatable((String)"block.resourcestrees.tree_simulator"), helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.TREE_SIMULATOR.get())), 168, 77);
    }

    public void draw(RecipeHolder<TreeSimulatorRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, 0, 0, 5.0f, 5.0f, 168, 77, 256, 256);
        ++this.tickCount;
        int arrowWidth = this.tickCount % 600 * 23 / 600;
        Identifier texture = ResourcesTrees.id("textures/gui/progress.png");
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, 54, 30, 0.0f, 0.0f, arrowWidth, 16, 22, 16);
        guiGraphics.fill(56, 53, 75, 72, -3750202);
        MutableComponent text = Component.translatable((String)"tooltip.resourcestrees.tickToGrow", (Object[])new Object[]{((TreeSimulatorRecipe)recipe.value()).ticksToGrow()});
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)text, 0, 70, -10066330, false);
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, RecipeHolder<TreeSimulatorRecipe> recipeHolder, IFocusGroup iFocusGroup) {
        TreeSimulatorRecipe recipe = (TreeSimulatorRecipe)recipeHolder.value();
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 21, 30).add(recipe.tree());
        List<TreeSimulatorOutput> drops = recipe.drops();
        for (int i = 0; i < drops.size(); ++i) {
            int finalI = i;
            ((IRecipeSlotBuilder)iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 93 + 18 * (i % 3), 12 + i / 3 * 18).add(drops.get(i).output())).addRichTooltipCallback((r, t) -> this.tooltipCallback(r, t, (TreeSimulatorOutput)drops.get(finalI)));
        }
    }

    private void tooltipCallback(IRecipeSlotView ignored, ITooltipBuilder tooltipBuilder, TreeSimulatorOutput output) {
        int chance = (int)(output.chance() * 100.0f);
        String chanceStr = String.format("Output Chance: %s", chance);
        tooltipBuilder.add((FormattedText)Component.literal((String)chanceStr).append("%").withColor(ChatFormatting.GRAY.getColor().intValue()));
    }
}

