/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.datagen;

import com.coolerpromc.resourcestrees.ResourcesTrees;
import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.datagen.model.ResourcesTypeTintSource;
import com.coolerpromc.resourcestrees.item.ModItems;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ModModelProvider
extends ModelProvider {
    public static final TextureSlot CROSS_TINTED_SLOT = TextureSlot.create((String)"cross_tinted");
    public static final ModelTemplate CROSS_TINTED = ModelTemplates.create((TextureSlot[])new TextureSlot[]{TextureSlot.CROSS, CROSS_TINTED_SLOT}).extend().parent(ResourcesTrees.id("block/cross_tinted")).build();

    public ModModelProvider(PackOutput output) {
        super(output, "resourcestrees");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_OAK_LEAVES.get(), -12012264);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_OAK_SAPLING.get(), -12012264);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), -10380959);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), -10380959);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), -8345771);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), -8345771);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), -12012264);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), -12012264);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), -12012264);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), -12012264);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), -12012264);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), -12012264);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get(), -209945);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), -209945);
        this.generateResourcesLeaves(blockModels, itemModels, (Block)ModBlocks.RESOURCES_PALE_OAK_LEAVES.get(), -8157056);
        this.generateResourcesSapling(blockModels, itemModels, (Block)ModBlocks.RESOURCES_PALE_OAK_SAPLING.get(), -8157056);
        this.generateFlatTintedItem(itemModels, (Item)ModItems.LEAF_FRAGMENT.get(), new ResourcesTypeTintSource(-1));
        this.blockWithExistingModel(blockModels, (Block)ModBlocks.TREE_SIMULATOR.get());
        this.generateTintedEssenceItem(itemModels, (Item)ModItems.FIRE_ESSENCE.get(), ItemModelUtils.constantTint((int)-1813725));
        this.generateTintedEssenceItem(itemModels, (Item)ModItems.WATER_ESSENCE.get(), ItemModelUtils.constantTint((int)-15235116));
        this.generateTintedEssenceItem(itemModels, (Item)ModItems.NATURE_ESSENCE.get(), ItemModelUtils.constantTint((int)-15045112));
        this.generateTintedEssenceItem(itemModels, (Item)ModItems.END_ESSENCE.get(), ItemModelUtils.constantTint((int)-3817845));
    }

    private void generateTintedEssenceItem(ItemModelGenerators itemModels, Item item, ItemTintSource tintSource) {
        Identifier itemModel = ModelTemplates.FLAT_ITEM.create(item, TextureMapping.layer0((Identifier)ResourcesTrees.id("item/essence")), itemModels.modelOutput);
        itemModels.itemModelOutput.accept(item, ItemModelUtils.tintedModel((Identifier)itemModel, (ItemTintSource[])new ItemTintSource[]{tintSource}));
    }

    private void generateFlatTintedItem(ItemModelGenerators itemModels, Item item, ItemTintSource tintSource) {
        Identifier itemModel = itemModels.createFlatItemModel(item, ModelTemplates.FLAT_ITEM);
        itemModels.itemModelOutput.accept(item, ItemModelUtils.tintedModel((Identifier)itemModel, (ItemTintSource[])new ItemTintSource[]{tintSource}));
    }

    private void generateResourcesLeaves(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block block, int defaultColor) {
        Identifier blockModel = TexturedModel.LEAVES.create(block, blockModels.modelOutput);
        blockModels.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((Identifier)blockModel)));
        itemModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.tintedModel((Identifier)blockModel, (ItemTintSource[])new ItemTintSource[]{new ResourcesTypeTintSource(defaultColor)}));
    }

    private void generateResourcesSapling(BlockModelGenerators blockModels, ItemModelGenerators itemModels, Block block, int defaultColor) {
        Identifier cross = this.getModelLocation(block, "");
        Identifier crossTinted = this.getModelLocation(block, "_layer1");
        TextureMapping textureMapping = new TextureMapping().put(TextureSlot.CROSS, cross).put(CROSS_TINTED_SLOT, crossTinted);
        Identifier blockModel = CROSS_TINTED.create(block, textureMapping, blockModels.modelOutput);
        Identifier itemModel = itemModels.generateLayeredItem(block.asItem(), cross, crossTinted);
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)new MultiVariant(WeightedList.of((Object)new Variant(blockModel)))));
        itemModels.itemModelOutput.accept(block.asItem(), ItemModelUtils.tintedModel((Identifier)itemModel, (ItemTintSource[])new ItemTintSource[]{ItemModelUtils.constantTint((int)-1), new ResourcesTypeTintSource(defaultColor)}));
    }

    private void blockWithExistingModel(BlockModelGenerators blockModels, Block block) {
        blockModels.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)new MultiVariant(WeightedList.of((Object)new Variant(this.getModelLocation(block, ""))))));
        blockModels.itemModelOutput.accept(block.asItem(), (ItemModel.Unbaked)new BlockModelWrapper.Unbaked(this.getModelLocation(block, ""), List.of()));
    }

    @NotNull
    protected Stream<? extends Holder<Item>> getKnownItems() {
        return BuiltInRegistries.ITEM.listElements().filter(itemReference -> Optional.of(BuiltInRegistries.ITEM.getKey((Object)((Item)itemReference.value()))).filter(Identifier2 -> Identifier2.getNamespace().equals("resourcestrees")).isPresent());
    }

    private Identifier getModelLocation(Block block, String suffix) {
        return ResourcesTrees.id("block/" + BuiltInRegistries.BLOCK.getKey((Object)block).getPath() + suffix);
    }
}

