/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.mixin;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlaceRecipe.class})
public abstract class ServerPlaceRecipeMixin<R extends Recipe<?>> {
    @Final
    @Shadow
    private Inventory inventory;
    @Final
    @Shadow
    private List<Slot> inputGridSlots;
    @Final
    @Shadow
    private int gridWidth;
    @Final
    @Shadow
    private int gridHeight;

    @Inject(method={"tryPlaceRecipe"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryPlaceRecipe(RecipeHolder<@NotNull R> recipe, StackedItemContents stackedItemContents, CallbackInfoReturnable<RecipeBookMenu.PostPlaceAction> cir) {
        CraftingRecipe craftingRecipe;
        boolean hasDataComponentIngredient;
        Recipe recipeValue = recipe.value();
        if (recipeValue instanceof CraftingRecipe && (hasDataComponentIngredient = (craftingRecipe = (CraftingRecipe)recipeValue).placementInfo().ingredients().stream().anyMatch(ing -> ing.isCustom() && ing.getCustomIngredient() instanceof DataComponentIngredient))) {
            if (this.resourcesTrees$canCraftWithDataComponents(craftingRecipe)) {
                this.clearGrid();
                this.resourcesTrees$placeRecipeWithDataComponents(recipe);
                this.inventory.setChanged();
                cir.setReturnValue((Object)RecipeBookMenu.PostPlaceAction.NOTHING);
            } else {
                this.clearGrid();
                this.inventory.setChanged();
                cir.setReturnValue((Object)RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE);
            }
        }
    }

    @Unique
    private boolean resourcesTrees$canCraftWithDataComponents(CraftingRecipe recipe) {
        PlacementInfo placementInfo = recipe.placementInfo();
        List ingredients = placementInfo.ingredients();
        IntList slotsToIngredientIndex = placementInfo.slotsToIngredientIndex();
        int[] allocatedCounts = new int[this.inventory.getContainerSize()];
        Iterator iterator = slotsToIngredientIndex.iterator();
        while (iterator.hasNext()) {
            Ingredient ingredient;
            int ingredientIndex = (Integer)iterator.next();
            if (ingredientIndex < 0 || ingredientIndex >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(ingredientIndex)).isEmpty()) continue;
            boolean found = false;
            for (int invSlot = 0; invSlot < this.inventory.getContainerSize(); ++invSlot) {
                int available;
                ItemStack stack = this.inventory.getItem(invSlot);
                if (stack.isEmpty() || !ingredient.test(stack) || (available = stack.getCount() - allocatedCounts[invSlot]) <= 0) continue;
                int n = invSlot;
                allocatedCounts[n] = allocatedCounts[n] + 1;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Unique
    private void resourcesTrees$placeRecipeWithDataComponents(RecipeHolder<@NotNull R> recipe) {
        int recipeHeight;
        int recipeWidth;
        Recipe recipeValue = recipe.value();
        PlacementInfo placementInfo = recipeValue.placementInfo();
        List ingredients = placementInfo.ingredients();
        IntList slotsToIngredientIndex = placementInfo.slotsToIngredientIndex();
        int[] takenCounts = new int[this.inventory.getContainerSize()];
        if (recipeValue instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipeValue;
            recipeWidth = shapedRecipe.getWidth();
            recipeHeight = shapedRecipe.getHeight();
        } else {
            recipeWidth = Math.min(slotsToIngredientIndex.size(), this.gridWidth);
            recipeHeight = (slotsToIngredientIndex.size() + recipeWidth - 1) / recipeWidth;
        }
        int offsetX = (this.gridWidth - recipeWidth) / 2;
        int offsetY = (this.gridHeight - recipeHeight) / 2;
        for (int i = 0; i < slotsToIngredientIndex.size(); ++i) {
            int recipeX;
            int gridX;
            int recipeY;
            int gridY;
            int gridSlot;
            Ingredient ingredient;
            int ingredientIndex = slotsToIngredientIndex.getInt(i);
            if (ingredientIndex < 0 || ingredientIndex >= ingredients.size() || (ingredient = (Ingredient)ingredients.get(ingredientIndex)).isEmpty() || (gridSlot = (gridY = offsetY + (recipeY = i / recipeWidth)) * this.gridWidth + (gridX = offsetX + (recipeX = i % recipeWidth))) < 0 || gridSlot >= this.inputGridSlots.size()) continue;
            Slot targetSlot = this.inputGridSlots.get(gridSlot);
            int invSlot = this.resourcesTrees$findSlotMatchingIngredient(ingredient, takenCounts);
            if (invSlot == -1) continue;
            ItemStack sourceStack = this.inventory.getItem(invSlot);
            ItemStack toPlace = sourceStack.split(1);
            targetSlot.set(toPlace);
            int n = invSlot;
            takenCounts[n] = takenCounts[n] + 1;
        }
        this.inventory.setChanged();
    }

    @Unique
    private int resourcesTrees$findSlotMatchingIngredient(Ingredient ingredient, int[] takenCounts) {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            int available;
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack) || (available = stack.getCount() - takenCounts[i]) <= 0) continue;
            return i;
        }
        return -1;
    }

    @Shadow
    protected abstract void clearGrid();
}

