/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees;

import com.coolerpromc.resourcestrees.block.ModBlocks;
import com.coolerpromc.resourcestrees.block.custom.ResourcesLeavesBlock;
import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.ModBlockEntities;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.block.entity.renderer.TreeSimulatorBlockEntityRenderer;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.coolerpromc.resourcestrees.item.custom.EssenceItem;
import com.coolerpromc.resourcestrees.item.custom.LeafFragmentItem;
import com.coolerpromc.resourcestrees.screen.ModMenuTypes;
import com.coolerpromc.resourcestrees.screen.custom.TreeSimulatorScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@Mod(value="resourcestrees", dist={Dist.CLIENT})
@EventBusSubscriber(modid="resourcestrees", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ResourcesTreesClient {
    public ResourcesTreesClient(ModContainer container) {
    }

    @SubscribeEvent
    static void onClientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, blockAndTintGetter, blockPos, i) -> {
            BlockEntity blockEntity;
            if (blockAndTintGetter != null && (blockEntity = blockAndTintGetter.getBlockEntity(blockPos)) instanceof ResourcesTypesBlockEntity) {
                ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
                return be.getColor();
            }
            return -12012264;
        }, new Block[]{(Block)ModBlocks.RESOURCES_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), (Block)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), (Block)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), (Block)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), (Block)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), (Block)ModBlocks.RESOURCES_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), (Block)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), (Block)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), (Block)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), (Block)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), (Block)ModBlocks.RESOURCES_CHERRY_LEAVES.get()});
    }

    @SubscribeEvent
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((itemStack, i) -> {
            Item patt0$temp;
            if (itemStack.has(ModDataComponents.TYPE)) {
                ResourceLocation type = (ResourceLocation)itemStack.get(ModDataComponents.TYPE);
                if (Block.byItem((Item)itemStack.getItem()) instanceof ResourcesSaplingBlock && i == 1 || Block.byItem((Item)itemStack.getItem()) instanceof ResourcesLeavesBlock || itemStack.getItem() instanceof LeafFragmentItem) {
                    return ResourcesTypes.byId(type, null).color();
                }
            }
            if ((patt0$temp = itemStack.getItem()) instanceof EssenceItem) {
                EssenceItem essenceItem = (EssenceItem)patt0$temp;
                return essenceItem.getColor();
            }
            return -1;
        }, new ItemLike[]{(ItemLike)ModBlocks.RESOURCES_OAK_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_SPRUCE_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_BIRCH_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_JUNGLE_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_ACACIA_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_DARK_OAK_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_CHERRY_SAPLING.get(), (ItemLike)ModBlocks.RESOURCES_OAK_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_SPRUCE_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_BIRCH_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_JUNGLE_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_ACACIA_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_DARK_OAK_LEAVES.get(), (ItemLike)ModBlocks.RESOURCES_CHERRY_LEAVES.get(), (ItemLike)ModItems.LEAF_FRAGMENT.get(), (ItemLike)ModItems.FIRE_ESSENCE.get(), (ItemLike)ModItems.WATER_ESSENCE.get(), (ItemLike)ModItems.NATURE_ESSENCE.get(), (ItemLike)ModItems.END_ESSENCE.get()});
    }

    @SubscribeEvent
    public static void onRegisterMenuScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.TREE_SIMULATOR.get(), TreeSimulatorScreen::new);
    }

    @SubscribeEvent
    public static void onEntityRenderersRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.TREE_SIMULATOR_BE.get(), TreeSimulatorBlockEntityRenderer::new);
    }
}

