/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.custom;

import com.coolerpromc.resourcestrees.block.custom.ResourcesSaplingBlock;
import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.item.ModItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ResourcesLeavesBlock
extends LeavesBlock
implements EntityBlock {
    public static final MapCodec<ResourcesLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(p_400250_ -> p_400250_.group((App)ResourcesLeavesBlock.propertiesCodec(), (App)ResourcesSaplingBlock.CODEC.fieldOf("sapling").forGetter(resourcesLeavesBlock -> resourcesLeavesBlock.sapling.get())).apply((Applicative)p_400250_, (p, s) -> new ResourcesLeavesBlock((BlockBehaviour.Properties)p, () -> s)));
    private final Supplier<ResourcesSaplingBlock> sapling;

    public ResourcesLeavesBlock(BlockBehaviour.Properties properties, Supplier<ResourcesSaplingBlock> sapling) {
        super(properties);
        this.sapling = sapling;
    }

    public MapCodec<? extends LeavesBlock> codec() {
        return CODEC;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List drops = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            ResourceLocation type = be.getResourcesType();
            ResourcesTypes resourcesTypes = ResourcesTypes.byId(type, (Level)builder.getLevel());
            if (drops.isEmpty()) {
                if (builder.getLevel().getRandom().nextFloat() < resourcesTypes.saplingChance()) {
                    ItemStack saplingDrop = this.sapling.get().asItem().getDefaultInstance();
                    saplingDrop.set(ModDataComponents.TYPE, (Object)type);
                    drops.add(saplingDrop);
                }
                ItemStack fragment = ModItems.LEAF_FRAGMENT.toStack();
                fragment.set(ModDataComponents.TYPE, (Object)type);
                drops.add(fragment.copy());
                if (builder.getLevel().getRandom().nextFloat() < resourcesTypes.secondaryDropChance()) {
                    drops.add(fragment.copy());
                }
            } else if (Block.byItem((Item)((ItemStack)drops.getFirst()).getItem()) instanceof ResourcesLeavesBlock) {
                ((ItemStack)drops.getFirst()).set(ModDataComponents.TYPE, (Object)type);
            }
        }
        return drops;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (stack.has((DataComponentType)ModDataComponents.TYPE.get())) {
                be.setResourcesType((ResourceLocation)stack.get((DataComponentType)ModDataComponents.TYPE.get()));
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
            stack.set(ModDataComponents.TYPE, (Object)be.getResourcesType());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 30;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ResourcesTypesBlockEntity(blockPos, blockState);
    }
}

