/*
 * Decompiled with CFR 0.152.
 */
package com.coolerpromc.resourcestrees.block.custom;

import com.coolerpromc.resourcestrees.block.entity.custom.ResourcesTypesBlockEntity;
import com.coolerpromc.resourcestrees.core.ResourcesTypes;
import com.coolerpromc.resourcestrees.datacomponent.ModDataComponents;
import com.coolerpromc.resourcestrees.worldgen.tree.ResourcesFoliagePlacer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class ResourcesSaplingBlock
extends SaplingBlock
implements EntityBlock {
    public static final MapCodec<ResourcesSaplingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TreeGrower.CODEC.fieldOf("tree").forGetter(p_304391_ -> p_304391_.treeGrower), (App)ResourcesSaplingBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("leaves").forGetter(block -> block.leaves)).apply((Applicative)instance, ResourcesSaplingBlock::new));
    private final ResourceLocation leaves;

    public ResourcesSaplingBlock(TreeGrower treeGrower, BlockBehaviour.Properties properties, ResourceLocation leaves) {
        super(treeGrower, properties);
        this.leaves = leaves;
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        List drops = super.getDrops(state, params);
        BlockEntity blockEntity = (BlockEntity)params.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (!drops.isEmpty() && be.getResourcesType() != null) {
                ((ItemStack)drops.getFirst()).set(ModDataComponents.TYPE, (Object)be.getResourcesType());
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ItemStack stack = super.getCloneItemStack(state, target, level, pos, player);
            stack.set(ModDataComponents.TYPE, (Object)be.getResourcesType());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (stack.has((DataComponentType)ModDataComponents.TYPE.get())) {
                be.setResourcesType((ResourceLocation)stack.get((DataComponentType)ModDataComponents.TYPE.get()));
            }
        }
    }

    public void advanceTree(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        ResourcesTypesBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (state.getBlock() instanceof ResourcesSaplingBlock && blockEntity instanceof ResourcesTypesBlockEntity && (be = (ResourcesTypesBlockEntity)blockEntity).getResourcesType() != null) {
            ResourceKey resourcekey1;
            Holder holder;
            ResourceLocation type = be.getResourcesType();
            ResourcesTypes resourcesTypes = ResourcesTypes.byId(type, (Level)level);
            ResourceKey resourcekey = this.treeGrower.getConfiguredMegaFeature(random);
            if (resourcekey != null && (holder = (Holder)level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(resourcekey).orElse(null)) != null) {
                ConfiguredFeature feature = (ConfiguredFeature)holder.value();
                for (int i = 0; i >= -1; --i) {
                    for (int j = 0; j >= -1; --j) {
                        TreeConfiguration oldConfig;
                        TreeConfiguration config;
                        if (!ResourcesSaplingBlock.isTwoByTwoSapling(state, (BlockGetter)level, pos, i, j)) continue;
                        BlockState blockstate = Blocks.AIR.defaultBlockState();
                        level.setBlock(pos.offset(i, 0, j), blockstate, 260);
                        level.setBlock(pos.offset(i + 1, 0, j), blockstate, 260);
                        level.setBlock(pos.offset(i, 0, j + 1), blockstate, 260);
                        level.setBlock(pos.offset(i + 1, 0, j + 1), blockstate, 260);
                        FeatureConfiguration featureConfiguration = feature.config();
                        if (featureConfiguration instanceof TreeConfiguration && Feature.TREE.place((FeatureConfiguration)(config = ResourcesSaplingBlock.createNewTree(type, oldConfig = (TreeConfiguration)featureConfiguration, random, pos, resourcesTypes.weight(), this.leaves)), (WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos.offset(i, 0, j))) {
                            return;
                        }
                        level.setBlock(pos.offset(i, 0, j), state, 260);
                        level.setBlock(pos.offset(i + 1, 0, j), state, 260);
                        level.setBlock(pos.offset(i, 0, j + 1), state, 260);
                        level.setBlock(pos.offset(i + 1, 0, j + 1), state, 260);
                        return;
                    }
                }
            }
            if ((resourcekey1 = this.treeGrower.getConfiguredFeature(random, this.treeGrower.hasFlowers((LevelAccessor)level, pos))) != null) {
                Holder holder2 = level.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE).get(resourcekey1).orElse(null);
                if (holder2 != null) {
                    TreeConfiguration oldConfig;
                    TreeConfiguration config;
                    boolean success;
                    ConfiguredFeature feature = (ConfiguredFeature)holder2.value();
                    level.setBlock(pos, Blocks.AIR.defaultBlockState(), 4);
                    FeatureConfiguration blockstate = feature.config();
                    if (blockstate instanceof TreeConfiguration && !(success = Feature.TREE.place((FeatureConfiguration)(config = ResourcesSaplingBlock.createNewTree(type, oldConfig = (TreeConfiguration)blockstate, random, pos, resourcesTypes.weight(), this.leaves)), (WorldGenLevel)level, level.getChunkSource().getGenerator(), random, pos))) {
                        level.setBlock(pos, state, 3);
                    }
                }
                return;
            }
        }
        super.advanceTree(level, pos, state, random);
    }

    public static TreeConfiguration createNewTree(ResourceLocation type, TreeConfiguration oldConfig, RandomSource randomSource, BlockPos pos, int weight, ResourceLocation leaves) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(leaves);
        return new TreeConfiguration.TreeConfigurationBuilder(oldConfig.trunkProvider, oldConfig.trunkPlacer, (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)oldConfig.foliageProvider.getState(randomSource, pos), 10).add((Object)block.defaultBlockState(), weight).build()), (FoliagePlacer)new ResourcesFoliagePlacer(oldConfig.foliagePlacer, type), oldConfig.minimumSize).build();
    }

    public static boolean isTwoByTwoSapling(BlockState state, BlockGetter level, BlockPos pos, int xOffset, int yOffset) {
        Block block = state.getBlock();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BlockEntity blockEntity1 = level.getBlockEntity(pos.offset(xOffset, 0, yOffset));
        BlockEntity blockEntity2 = level.getBlockEntity(pos.offset(xOffset + 1, 0, yOffset));
        BlockEntity blockEntity3 = level.getBlockEntity(pos.offset(xOffset, 0, yOffset + 1));
        BlockEntity blockEntity4 = level.getBlockEntity(pos.offset(xOffset + 1, 0, yOffset + 1));
        if (blockEntity instanceof ResourcesTypesBlockEntity) {
            ResourcesTypesBlockEntity be = (ResourcesTypesBlockEntity)blockEntity;
            if (blockEntity1 instanceof ResourcesTypesBlockEntity) {
                ResourcesTypesBlockEntity be1 = (ResourcesTypesBlockEntity)blockEntity1;
                if (blockEntity2 instanceof ResourcesTypesBlockEntity) {
                    ResourcesTypesBlockEntity be2 = (ResourcesTypesBlockEntity)blockEntity2;
                    if (blockEntity3 instanceof ResourcesTypesBlockEntity) {
                        ResourcesTypesBlockEntity be3 = (ResourcesTypesBlockEntity)blockEntity3;
                        if (blockEntity4 instanceof ResourcesTypesBlockEntity) {
                            ResourcesTypesBlockEntity be4 = (ResourcesTypesBlockEntity)blockEntity4;
                            ResourceLocation type = be.getResourcesType();
                            ResourceLocation type1 = be1.getResourcesType();
                            ResourceLocation type2 = be2.getResourcesType();
                            ResourceLocation type3 = be3.getResourcesType();
                            ResourceLocation type4 = be4.getResourcesType();
                            BlockState state1 = level.getBlockState(pos.offset(xOffset, 0, yOffset));
                            boolean cond1 = state1.is(block) && type1.equals((Object)type);
                            BlockState state2 = level.getBlockState(pos.offset(xOffset + 1, 0, yOffset));
                            boolean cond2 = state2.is(block) && type2.equals((Object)type);
                            BlockState state3 = level.getBlockState(pos.offset(xOffset, 0, yOffset + 1));
                            boolean cond3 = state3.is(block) && type3.equals((Object)type);
                            BlockState state4 = level.getBlockState(pos.offset(xOffset + 1, 0, yOffset + 1));
                            boolean cond4 = state4.is(block) && type4.equals((Object)type);
                            return cond1 && cond2 && cond3 && cond4;
                        }
                    }
                }
            }
        }
        return false;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new ResourcesTypesBlockEntity(blockPos, blockState);
    }

    public ItemStack getLeaves(ResourceLocation type) {
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.get(this.leaves)).getDefaultInstance();
        stack.set(ModDataComponents.TYPE, (Object)type);
        return stack;
    }

    public ResourceLocation getLeaves() {
        return this.leaves;
    }

    public TreeGrower getTreeGrower() {
        return this.treeGrower;
    }
}

